USE hahn;

$path = "//home/geoadv/seregapanov/fraud_flow/cp_agency";
$cd_all_with_tiers = "statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers";

$mean_cp_budget = "//home/geoadv/seregapanov/common/cp_budget_21";

$agency_agregators = SELECT [523581, 28047771, 2371403, 2124001, 67140973, 9830514, 1332316, 35786724, 32805081, 5946133, 1621799, 322057, 472729, 36002706];


$prof_agency_path = "home/balance/prod/bo/v_contract_apex_full";

-- Список агентств про
$agency_pro_list = SELECT
    AGGREGATE_LIST(DISTINCT agency_id) AS AgencyID
FROM $prof_agency_path
WHERE
    agency_id IS NOT NULL
    AND finish_dt >= "2022-02-01"
    AND (wsale_ag_prm_awrd_sc_tp like "Премиум%" OR wsale_ag_prm_awrd_sc_tp like "РМП%");

-- Список агентств база
$agency_base_list = SELECT
    AGGREGATE_LIST(DISTINCT agency_id) AS AgencyID
FROM $prof_agency_path
WHERE
    agency_id IS NOT NULL
    AND finish_dt >= "2022-02-01"
    AND (wsale_ag_prm_awrd_sc_tp like "Баз%");

$cp_table = SELECT
    counterparty,
    client_id,
    client_tier,
    agency_id,
    CASE
        WHEN operator_role LIKE 'freelance%' OR curr_agency_tier ILIKE 'самоходно%' THEN 'freelancer'
        WHEN ListHas($agency_agregators, agency_id) THEN 'agregator'
        WHEN ListHas($agency_pro_list, agency_id) THEN "agency (pro)"
        WHEN ListHas($agency_base_list, agency_id) THEN "agency (base)"
        ELSE "agency (other)"
    END AS agency_type,
    agency_name,
    first_day,
    last_day,
    ROW_NUMBER() OVER (PARTITION BY curr_counterparty_name ORDER BY Cast(first_day AS Date)) AS agency_client_number    
FROM
    $cd_all_with_tiers
WHERE
    curr_counterparty_name is not NULL
    AND agency_id IS NOT NULL
    AND CAST(month as date) >= CAST("2020-01-01" as date)
    AND money IS NOT NULL
    AND product = 'Общая выручка'
    AND currency = 'rur'
    AND excluded_revenue = "false"
GROUP BY
    curr_counterparty_name as counterparty,
    clientid as client_id,
    operator_role,
    CASE
        WHEN curr_reporting_tier LIKE 'Tier 0' THEN 'Tier 0'
        WHEN curr_reporting_tier LIKE 't1' THEN 'Tier 1'
        WHEN curr_reporting_tier LIKE '%SB%' OR curr_reporting_tier LIKE '%SMB%' THEN 'Tier SMB'
        ELSE 'Tier 2'
    END AS client_tier,
    curr_agency_tier,
    agency_id,
    agency_name,
    first_day,
    last_day
;

INSERT INTO $path WITH TRUNCATE
SELECT 
    a.*,
    COALESCE(b.mean_total_revenue, 0) as mean_money
FROM $cp_table as a
LEFT JOIN $mean_cp_budget as b
USING(counterparty)
