USE hahn;
$cd_all_with_tiers = "statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers";
$write_path = "home/newsmb/serge-ssk/situation_monitoring/all_revenue";

-- test
$operator_role_to_client_type = ($operator_role) -> {
    $client_type = IF($operator_role == "agency", "Агентский", 
    IF($operator_role == "client", "Прямой", "Прочее (не должно быть)"));
    RETURN $client_type;
};

$money_to_client_size = ($money) -> {
    $client_size = IF(
    $money < 20 * 1000, '20K-',
    IF(
        $money < 500 * 1000, '20K-500K',
            IF(
                $money < 1000 * 1000, '500K-1M',
                IF(
                    $money < 50 * 1000 * 1000, '1M-50M',
                    '50M+'
                )
            )
    )
);
    RETURN $client_size;
};

$choice_data = ($period) -> {
    $true_false = IF(($period > '2020-01-01'), True, False);
    RETURN $true_false;
};

-- Сопоставляем каждому клиенту его средний за год чек
$mean_budget_clients = SELECT
    clientid AS clientid,
    AVG(money) AS mean_total_revenue,
FROM $cd_all_with_tiers
WHERE
    scale == "months"
    AND product == "Общая выручка"
    AND period LIKE '2021%'
    AND money IS NOT NULL
GROUP BY clientid;

$select_prepare_for_mean_budget = SELECT 
    a.clientid AS client_id,
    a.money AS money,
    a.curr_industry AS industry,
    a.curr_macroindustry AS macroindustry,
    a.period AS period,
    $operator_role_to_client_type(a.operator_role) AS client_type,
    $money_to_client_size(b.mean_total_revenue) AS client_size,
FROM $cd_all_with_tiers AS a 

INNER JOIN 

$mean_budget_clients AS b 

ON a.clientid == b.clientid
WHERE
    scale == "days"
    AND product == "Общая выручка"
    AND $choice_data(period)
    AND money IS NOT NULL;

INSERT INTO $write_path WITH TRUNCATE
SELECT 
    SUM(money) AS money,
    period AS period,
    period_week AS period_week,
    year AS year,
    client_type AS client_type,
    client_size AS client_size,
    industry AS industry,
FROM $select_prepare_for_mean_budget
WHERE
    period_week < DateTime::GetWeekOfYear(CurrentTzDatetime("Europe/Moscow"))
GROUP BY
    period,
    DateTime::GetWeekOfYear(CAST(period AS Date)) AS period_week,
    DateTime::GetYear(CAST(period AS Date)) AS year,
    client_type,
    client_size,
    industry
;
