use hahn;

$cd_all_tiers = "statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers";
$agency_tiers = "//home/geoadv/seregapanov/revenue_dynamics/agency_tier";

$path = "//home/geoadv/seregapanov/revenue_dynamics/rev_by_agency_tier";

INSERT INTO $path WITH TRUNCATE 
select
    week_,
    DateTime::Format("%Y-%m-%d")(DateTime::MakeDatetime(DateTime::Parse("%Y")('2022')) + DateTime::IntervalFromDays(7 * (week_ - 1) + 1 - DateTime::GetDayOfWeek(DateTime::Parse("%Y-%m-%d")('2022-01-01')))) as date_,
    b.ag_tier as agency_tier,
    SUM(money) as sum_money
from $cd_all_tiers as a
JOIN $agency_tiers as b
ON a.agency_id == b.agency_id
where 
    DateTime::GetYear(Cast(`day` as Date))>=2022
    and DateTime::GetWeekOfYear(Cast(`day` as Date)) < DateTime::GetWeekOfYear(CurrentTzDatetime("Europe/Moscow"))
    and product = 'Общая выручка'
    and currency = 'rur'
    and excluded_revenue = 'false'
    and money is not null
group by
    DateTime::GetWeekOfYear(CAST(`day` as Date)) as week_,
    b.ag_tier
;

