USE hahn;
$path = "//home/geoadv/seregapanov/revenue_dynamics/rev_by_client_tier";

$agency_agregators = SELECT [523581, 28047771, 2371403, 2124001, 67140973, 9830514, 1332316, 35786724, 32805081, 5946133, 1621799, 322057, 472729, 36002706];

INSERT INTO $path WITH TRUNCATE 
SELECT 
    year_,
    week_,
    DateTime::Format("%Y-%m-%d")(DateTime::MakeDatetime(DateTime::Parse("%Y")('2022')) + DateTime::IntervalFromDays(7 * (week_ - 1) + 1 - DateTime::GetDayOfWeek(DateTime::Parse("%Y-%m-%d")('2022-01-01')))) AS 
    date_,
    clienttype,
    tier,
    SUM(money) AS sum_money
FROM `//statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers`
WHERE 
    DateTime::GetYear(Cast(`day` AS Date))>=2020
    AND product = 'Общая выручка'
    AND currency = 'rur'
    AND excluded_revenue = 'false'
    AND money IS NOT NULL
GROUP BY  
    DateTime::GetYear(CAST(`day` AS Date)) AS year_,
    DateTime::GetWeekOfYear(CAST(`day` AS Date)) AS week_,
    CASE
        WHEN operator_role LIKE 'client' THEN 'client'
        WHEN operator_role LIKE 'freelance%' OR curr_agency_tier ILIKE 'самоходно%' THEN 'freelancer'
        WHEN ListHas($agency_agregators,agency_id) THEN 'agregator'
        ELSE 'agency'
    END AS clienttype,
    CASE
        WHEN curr_reporting_tier LIKE 'Tier 0' THEN 'Tier 0'
        WHEN curr_reporting_tier LIKE 't1' THEN 'Tier 1'
        WHEN curr_reporting_tier LIKE '%SB%' OR curr_reporting_tier LIKE '%SMB%' THEN 'Tier SMB'
        ELSE 'Tier 2'
    END AS tier
HAVING  week_<DateTime::GetWeekOfYear(CurrentTzDatetime("Europe/Moscow"))
