use hahn;

PRAGMA AnsiInForEmptyOrNullableItemsCollections;
$agency_agregators = (523581, 28047771, 2371403, 2124001, 67140973, 9830514, 1332316, 35786724, 32805081, 5946133, 1621799, 322057, 472729, 36002706);

-- Вычисление эпохи по месяцам
$epoch = ($a,$b) -> {
    return (CAST(DateTime::GetMonth(CAST($a as DATE)) as INT) - 
            CAST(DateTime::GetMonth(CAST($b as DATE)) as INT)) + 
            12U * (
                DateTime::GetYear(CAST($a as DATE)) - 
                DateTime::GetYear(CAST($b as DATE))
            )
    };
$date_format = DateTime::Format("%Y-%m-%d");

-- В формат months из cd_all_with_tiers
$m_start = ($a) -> {
return $date_format(DateTime::StartOfMonth(cast($a as DATE)))
};

--Считали предобработанную табличку и посчитали эпохи жизни клиента
$base = 
select 
    b.*,
    $epoch(month, min_month_over_all) over (partition by clientid) as client_epoch
from `//home/newsmb/ma-iankova/cd_all_base_ag_an` as b
;

--Разбивка по agency_id elama
$base1 = 
select 
    b.*,
    case 
        when operator_role = 'elama' THEN `agency_owner_login` 
        when operator_role = 'freelancer_unofficial' or operator_role = 'freelancer_official' then cast(`operator_clientid` as string)||'_f'
        else cast(agency_id as string?)
    end as agency_id_new
from $base AS b
left join `//home/geo-analytics/antgor146/direct/elama_new_accounts` as e
on b.client_login = e.account_name
;

-- Кол-во клиентов агентств по эпохам
$agency_params = 
select 
    agency_id_new, 
    agency_min_month,
    month,
    count(distinct clientid) as cnt_clts, 
    $epoch(month, agency_min_month) as agency_epoch,
from $base1
where agency_id_new is not null
group by agency_id_new, month, agency_min_month
;

-- кол-во клиентов агентства в первый месяц 
$agency_clnts = 
select
    agency_id_new, 
    SUM_IF(cnt_clts,agency_epoch = 0) as ag_clts_0
from $agency_params as a
group by agency_id_new
;

-- Ретеншн клиентов в агентстве
$client_retn = 
select
    agency_id_new, 
    SUM_IF(cnt_clts,client_epoch = 2)*1.0
    /SUM_IF(cnt_clts,client_epoch = 0)* 1.0 as retn_by_clnts,
from 
    (
        select agency_id_new, month, client_epoch, count(distinct clientid) as cnt_clts
        from $base1
        group by agency_id_new, month, client_epoch
    ) as a
group by agency_id_new
;


-- INSERT INTO `//home/geo-analytics/miankova/agency_analytics`  WITH TRUNCATE 
$res = 
select 
    b.agency_id_new as agency_id_new,
    b.agency_id as agency_id,
    a.agency_min_month as agency_min_month,
    all_money,
    clientid, 
    --client_login,
    b.client_epoch as client_epoch,
    --b.operator_clientid as operator_clientid,
    curr_agency_tier,
    curr_industry, 
    min_month_over_all,
    min_month, 
    money_start,
    b.month as month, 
    operator_role,
    product,
    tier,
    year,
    cnt_clts,
    ag_clts_0,
    retn_by_clnts,
    agency_epoch,

    CASE 
        when retn_by_clnts < 0.2 then '<0.2'
        when retn_by_clnts < 0.5 then '0.2 - 0.5'
        when retn_by_clnts < 0.7 then '0.5 - 0.7'
        else '>0.7'
    end as reth_cat_clnts

--from `//home/geo-analytics/miankova/cd_all_res_ag_an_all` as b
from $base1 as b
left join 
    $agency_clnts as ar
    on b.agency_id_new = ar.agency_id_new
left join 
    $client_retn as cr
    on b.agency_id_new = cr.agency_id_new
left join $agency_params as a
on 
    b.agency_id_new = a.agency_id_new 
    and b.month = a.month
    and b.agency_min_month = a.agency_min_month
;

$contr = 
SELECT
    DISTINCT agency_id, 
    min(substring(dt, null, 7)||'-01') as start_dt,
    max(finish_dt) as finish_dt
FROM `//home/balance/prod/bo/v_contract_apex_full`
WHERE
    agency_id IS NOT NULL
    AND (wsale_ag_prm_awrd_sc_code IN (1, 23, 28, 33))
group by
    agency_id
;

$res2 = 
select a.*,
    -- coalesce(b.num_contract, 0) as num_contract,
        case
        when coalesce(b.start_dt, '2022-01-01') <= a.month 
            and coalesce(b.finish_dt, '2021-01-01') > a.month then 1
        else 0
    end as num_contract,
    sum(a.all_money) over (partition by a.agency_id_new, a.month, a.product) as agency_money,
    max(a.all_money) over (partition by a.agency_id_new, a.month, a.product) as max_money,
    b.start_dt as frst_contract_date
from $res as a
left join 
    $contr as b 
    using(agency_id)
-- https://yql.yandex-team.ru/Operations/YT80wNjKS5vGHhjraeDLRtD6vyloZ2etHMdjn8AMXiU=
-- `//home/geo-analytics/miankova/agency_id_to_contract_num_month1` as b
-- on a.agency_id = b.agency_id and a.month = b.month_contract


;

--INSERT INTO `//home/geo-analytics/miankova/agency_analytics_contr` WITH TRUNCATE  
$res3 = 
select 
    r.*,
    case
        when 
            (operator_role = 'agency' or operator_role = 'elama') and
            --and product = 'Директ' 
            num_contract = 0 and cnt_clts < 5 
            then True
        else False
    end as no_contract_reason_clnts,
    case
        when 
            (operator_role = 'agency' or operator_role = 'elama') and
            --and product = 'Директ' 
            num_contract = 0 and LAG(agency_money) over w1 < 200000  
            then True
            else False
    end as no_contract_reason_money,

    case
        when 
            (operator_role = 'agency' or operator_role = 'elama') and
            num_contract = 0 
            and (
                LAG(max_money/agency_money) over w1 > 0.7
                or LAG(max_money/agency_money, 2) over w1 > 0.7
                or LAG(max_money/agency_money, 3) over w1 > 0.7)
            then True
        else False
    end as no_contract_reason_budget

from $res2 as r
window w1 as (partition by clientid order by month)
;



insert into `//home/newsmb/ma-iankova/agency_analytics_contr` with truncate
select t1.*,
    case 
        when t1.agency_id_new is not null and frst_contract_date > t1.month then '-1'
        when t1.agency_id_new is not null and frst_contract_date = t1.month then '0'
        when t1.agency_id_new is not null and frst_contract_date < t1.month then cast($epoch(t1.month, frst_contract_date) as string)
        else '-2'
    end as contract_time,
    case 
        when t1.agency_id is not null and frst_contract_date <= t1.month then $epoch(t1.month, frst_contract_date)
        when t1.agency_id is not null and frst_contract_date > t1.month then - $epoch(`frst_contract_date`, `month`)
        else null
    end as contract_epoch,
    case
        WHEN agency_min_month = frst_contract_date then 'Договор с первого месяца'
        WHEN $epoch(frst_contract_date, agency_min_month) < 4 then 'Через 1-3 месяца'
        WHEN $epoch(frst_contract_date, agency_min_month) < 7 then 'Через 4-6 месяцев'
        WHEN $epoch(frst_contract_date, agency_min_month) < 12 then 'Через 6-12 месяцев'
        WHEN $epoch(frst_contract_date, agency_min_month) < 24 then 'Через 1-2 года'
        WHEN $epoch(frst_contract_date, agency_min_month) < 36 then 'Через 2-3 года'
        WHEN $epoch(frst_contract_date, agency_min_month) >= 36 then 'Через 3 года и более'
        ELSE 'Нет договора' 
    END as frst_contract_category
-- from `//home/geo-analytics/miankova/agency_analytics_contr` as t1
from $res3 as t1