use hahn;

$start_values = 
select 
    operator_role,
    clientid,
    year, 
    product, tier, curr_industry,
    curr_agency_tier,
    agency_id,
    CASE 
        WHEN sum(money_start) < 1000 THEN '<1k'
        WHEN sum(money_start) < 50000 THEN '<50k'
        WHEN sum(money_start) < 100000 THEN '50k-100k'
        WHEN sum(money_start) < 600000 THEN '100k-600k'
        WHEN sum(money_start) < 1000000 THEN '600k-1M'
        ELSE '>1M'
    END as budget_cat,
    ROW_NUMBER() over (partition by year order by sum(all_money) DESC) as t0,
    
from `//home/geoadv/geosmb/analytics/miankova/cd_all_base_ag_an`
where 
    min_month = month
    -- and agency_id is not null and operator_role = 'agency'
group by year, agency_id, clientid, operator_role, product, tier, curr_agency_tier, curr_industry;


$res = 
SELECT 
    a.year as year, 
    a.month as month,
    DateTime::GetMonth(CAST(a.min_month as DATE)) as min_month,
    CAST(a.min_month as DATE) as min_month_date,
    a.operator_role as operator_role,
    b.budget_cat as budget_cat,
    a.tier as tier,
    a.curr_industry as industry,
    a.product as product,
    sum(all_money) as money,
    sum(money_start) as money_start, 
    a.agency_id as agency_id,
    a.clientid as clientid,
    b.t0 as t0,
    b.curr_agency_tier as curr_agency_tier,
    case 
        when b.t0 is null then null
        when b.t0 < 11 then 'Top 10'
        when b.t0 < 21 then 'Top 11-20'
        when b.t0 < 51 then 'Top 21-50'
        when b.t0 < 101 then 'Top 51-100'
        else null
    end as Top0,
    a.agency_min_month as agency_min_month
from 
    `//home/geoadv/geosmb/analytics/miankova/cd_all_base_ag_an` as a
left join 
    $start_values as b
    using(clientid, year, operator_role, product, tier, curr_industry, curr_agency_tier)
GROUP BY 
    a.year, a.month, a.operator_role, b.budget_cat, 
    a.min_month, a.tier, a.curr_industry,
    a.clientid, b.t0, a.product, 
    b.curr_agency_tier, a.agency_id, a.agency_min_month
    ;


$a = 
select year, month, min_month, 
    min_month_date,
    'all' as operator_role,
    budget_cat, 
    tier, industry, 
    sum(money) as money,
    sum(money_start) as money_start,
    agency_id,
    clientid,
    product,
    t0,
    Top0,
    curr_agency_tier, 
    agency_min_month
--from `//home/geo-analytics/miankova/cd_all_res_ag_an`
from $res
group by 
    year, month, min_month, budget_cat, 
    tier, industry, clientid, t0, product,Top0,
    curr_agency_tier, min_month_date, 
    agency_min_month, agency_id;


INSERT INTO `//home/geoadv/geosmb/analytics/miankova/cd_all_res_ag_an_all` WITH TRUNCATE
select * from $a
union all 
select * from $res;
