use hahn;

$read_path = '//home/geoadv/geosmb/analytics/miankova/cd_all_base';

$mnth3=
SELECT 
    clientid, 
    avg(all_money) as avg_3mnth_money
FROM 
    $read_path
WHERE 
    epoch < 3
GROUP BY 
    clientid;

$mnth12=
SELECT 
    clientid, 
    avg(all_money) as avg_12mnth_money
FROM 
    $read_path
WHERE 
    epoch < 12
GROUP BY 
    clientid;

$mnth1=
SELECT 
    clientid, 
    avg(all_money) as avg_1mnth_money
FROM 
    $read_path
WHERE 
    epoch < 1
GROUP BY 
    clientid;

$all_money = 
SELECT 
    b.*, a.*, c.*, d.*,
    CASE 
        WHEN avg_3mnth_money > 60000 THEN '>60k'
        WHEN avg_3mnth_money > 20000 THEN '20k-60k'
        WHEN avg_3mnth_money > 10000 THEN '10k-20k'
        WHEN avg_3mnth_money > 8000 THEN '8k-10k'
        WHEN avg_3mnth_money > 6000 THEN '6k-8k'
        WHEN avg_3mnth_money > 4000 THEN '4k-6k'
        WHEN avg_3mnth_money > 2000 THEN '2k-4k'
        WHEN avg_3mnth_money > 1000 THEN '1k-2k'
        -- WHEN avg_3mnth_money < 0.02 THEN '0.01'
        ELSE '<1k'
    END as start_3_mnth_money_category, 

    CASE 
        WHEN avg_12mnth_money > 60000 THEN '>60k'
        WHEN avg_12mnth_money > 20000 THEN '20k-60k'
        WHEN avg_12mnth_money > 10000 THEN '10k-20k'
        WHEN avg_12mnth_money > 8000 THEN '8k-10k'
        WHEN avg_12mnth_money > 6000 THEN '6k-8k'
        WHEN avg_12mnth_money > 4000 THEN '4k-6k'
        WHEN avg_12mnth_money > 2000 THEN '2k-4k'
        WHEN avg_12mnth_money > 1000 THEN '1k-2k'
        ELSE '<1k'
    END as start_12_mnth_money_category,

    CASE 
        WHEN avg_1mnth_money > 60000 THEN '>60k'
        WHEN avg_1mnth_money > 20000 THEN '20k-60k'
        WHEN avg_1mnth_money > 10000 THEN '10k-20k'
        WHEN avg_1mnth_money > 8000 THEN '8k-10k'
        WHEN avg_1mnth_money > 6000 THEN '6k-8k'
        WHEN avg_1mnth_money > 4000 THEN '4k-6k'
        WHEN avg_1mnth_money > 2000 THEN '2k-4k'
        WHEN avg_1mnth_money > 1000 THEN '1k-2k'
        ELSE '<1k'
    END as start_1_mnth_money_category,
    
    CASE
        WHEN min_month < '2018-04-01' THEN '2018 1 кв'
        WHEN min_month < '2018-07-01' THEN '2018 2 кв'
        WHEN min_month < '2018-10-01' THEN '2018 3 кв'
        WHEN min_month < '2019-01-01' THEN '2018 4 кв'
        WHEN min_month < '2019-04-01' THEN '2019 1 кв'
        WHEN min_month < '2019-07-01' THEN '2019 2 кв'
        WHEN min_month < '2019-10-01' THEN '2019 3 кв'
        WHEN min_month < '2020-01-01' THEN '2019 4 кв'
        WHEN min_month < '2020-04-01' THEN '2020 1 кв'
        WHEN min_month < '2020-07-01' THEN '2020 2 кв'
        WHEN min_month < '2020-10-01' THEN '2020 3 кв'
        WHEN min_month < '2021-01-01' THEN '2020 4 кв'
        WHEN min_month < '2021-04-01' THEN '2021 1 кв'
        WHEN min_month < '2021-07-01' THEN '2021 2 кв'
        ELSE '2021 3 кв'
    END as start_year_category

FROM 
    $read_path  as b
LEFT JOIN 
    $mnth3 as a
    ON a.clientid = b.clientid
LEFT JOIN 
    $mnth12 as c
    ON c.clientid = b.clientid
LEFT JOIN 
    $mnth1 as d
    ON d.clientid = b.clientid
;

INSERT INTO `//home/geoadv/geosmb/analytics/miankova/cd_all_avg_money` WITH TRUNCATE
select 
    * 
from 
    $all_money
order by 
    avg_1mnth_money, avg_3mnth_money, clientid;
