use hahn;

-- создание базовой таблицы для дэша https://datalens.yandex-team.ru/77hfep3outok0-agency-analytics, 
-- min_month - первый месяц открутки клиента в текущем году
-- min_month_over_all - первый месяц открутки клиента за все время
-- agency_min_month - месяц первого клиента агентства
$base = 
    select
        tier, 
        clientid,
        client_login,
        agency_id,
        curr_industry,
        month,
        operator_role,
        product,
        curr_agency_tier,
        operator_clientid,
-- для фриланса
        --min(DateTime::GetMonth(CAST(month as DATE)))
        min(month)
            over (partition by clientid, CAST(DateTime::GetYear(CAST(month as DATE)) as INT),
            tier, agency_id, curr_industry,operator_role,product) 
            as min_month,
        min(month)
            over (partition by clientid,
            tier, agency_id, curr_industry,operator_role,product) 
            as min_month_over_all,

        min_by(sum(money), month) 
            over (partition by clientid, CAST(DateTime::GetYear(CAST(month as DATE)) as INT),
            tier, agency_id, curr_industry,operator_role,product) 
            as money_start,
            
        min(month)
            over (partition by agency_id) 
            as agency_min_month,

        CAST(DateTime::GetYear(CAST(month as DATE)) as INT) as year,
        sum(money) as all_money
    FROM 
        `//statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers` 
    flatten list by product_list as product_flattened
    WHERE  
        money > 0 
        and scale = 'months'
        and currency = 'rur'
        and operator_role is not null
        and product_flattened is not null
    GROUP BY curr_industry, month, curr_reporting_tier as tier, clientid, agency_id, operator_role, product_flattened as product, curr_agency_tier, client_login, operator_clientid
;


INSERT INTO `//home/geoadv/geosmb/analytics/miankova/cd_all_base_ag_an` WITH TRUNCATE
select 
    *
from $base
;
