use hahn;

$diff = ($a,$b) -> {
    return (CAST(DateTime::GetMonth(CAST($a as DATE)) as INT) - 
            CAST(DateTime::GetMonth(CAST($b as DATE)) as INT)) + 
            12U * (
                DateTime::GetYear(CAST($a as DATE)) - 
                DateTime::GetYear(CAST($b as DATE))
            )
    };

$base=
select 
    clientid, 
    agency_id, tier,
    operator_role,
    month,
    MIN(month) over (partition by clientid) as min_month,
    sum(money) as all_money, 
    $diff(month, MIN(month) over (partition by clientid)) as epoch,
    operator_role || ' ' || tier as operator_and_tier,
    product,
    curr_industry as industry
FROM 
    `//statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers` 
WHERE  
     money > 0 
     and scale = 'months'
     and currency = 'rur'
     -- and product = 'Общая выручка'
     AND (curr_reporting_tier LIKE 'SMB%' OR curr_reporting_tier LIKE 'SB%')
GROUP BY
    agency_id,
    curr_reporting_tier as tier,
    month,
    clientid,
    operator_role,
    product,
    curr_industry
;

INSERT INTO `//home/geoadv/geosmb/analytics/miankova/cd_all_base` WITH TRUNCATE
select 
    * 
from 
    $base
where 
    all_money > 1000;
