use hahn;

$epoch = ($today, $start_day) -> {
    return 
        case 
        when $today<$start_day then -1
        else
        DateTime::ToDays(cast($today as date) - cast($start_day as Date))/ 7
    end
};

$res0 = 
select 
    `clientid`,
    epoch,
    `min_day`,
    `group_type`,
    cast(DateTime::MakeDate(DateTime::StartOfWeek(cast(min_day as date)))as string) as start_week,
    sum(`count_new_money`) as `count_new_money`,
    sum(`spends`) as `spends`,
    sum(`money`) as `money`,
    sum(`new_money`) as `new_money`
from 
    `//home/geoadv/geosmb/analytics/miankova/exp/exp_groups_days1`
group by
    clientid,
    coalesce($epoch(day, min_day), -1) as epoch,
    group_type,
    min_day
;

$res1 = 
select 
    res.*,
    sum(new_money) over w1 as sum_new_money,
    sum(spends) over w1 as sum_spends,
from
    $res0 as res
WINDOW
    w1 AS (partition by clientid order by epoch asc ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW),
    w2 as (partition by clientid order by epoch asc ROWS BETWEEN 3 PRECEDING AND CURRENT ROW);

INSERT INTO `//home/geoadv/geosmb/analytics/miankova/exp/exp_new_money_1week` WITH TRUNCATE 
SELECT 
    r.*, 
    (coalesce(lag(r.sum_new_money - r.sum_spends) over w1, 0) +
    r.new_money) / r.spends   as spends_perc,
    r.sum_new_money - r.sum_spends as balance,
    coalesce(lag(r.spends) over w1, 0) as lag_spends,
    coalesce(lag(r.sum_new_money - r.sum_spends) over w1, 0) as balance_lag,
    new.new_money as start_new_money,
    CASE    
        when new.new_money < 10000 then '<10k'
    when new.new_money < 40000 then '10к-40к'
    when new.new_money < 100000 then '40к-100k'
    when new.new_money < 300000 then '100к-300k'
    else '>300к'
    end as start_new_money_cat
from 
    $res1 as r
left join
    (SELECT 
        clientid,
        new_money
    from $res1
    where 
        epoch = -1) as new
    using(clientid)
WINDOW
    w1 as (partition by r.clientid order by epoch asc)