use hahn;

$today_2m = DateTime::Format("%Y-%m-%d")(DateTime::ShiftMonths((CurrentUtcDate()), -2));
$date_format = DateTime::Format("%Y-%m-%d");
$today_1m = DateTime::Format("%Y-%m-%d")(DateTime::ShiftMonths((CurrentUtcDate()), -1));
$m_start = ($a) -> {
return $date_format(DateTime::StartOfMonth(cast($a as DATE)))
};


-- $base=
$ret_control=
SELECT 
    epoch, 
    -- count(distinct clientid) as clients,
    -- max(count(distinct clientid)) over (partition by start_week) as clients0,
    1.0*count(distinct clientid)/
    max(count(distinct clientid)) over () as ret,
from 
    `//home/geoadv/geosmb/analytics/miankova/exp/exp_new_money_1week`
WHERE 
    group_type = 'Контроль'
    and start_week <= $today_2m
    and epoch >= 0
    and start_week >= '2021-12-01'
    and `start_new_money` < 200000
GROUP BY    
    epoch
;
-- SELECT *
-- from $ret_control;

$test = 
SELECT 
    start_week,
    epoch, 
    avg(spends) as spends,
    count(distinct clientid) as clients,
    max(count(distinct clientid)) over (partition by start_week) as clients0,
from 
    `//home/geoadv/geosmb/analytics/miankova/exp/exp_new_money_1week`
WHERE 
    group_type = 'Тест'
    and epoch >= 0
GROUP BY    
    epoch,
    start_week
;

-- select * from $test;


$spends = 
SELECT 
    epoch, 
    -- sum(clients0) * ret as clients,
    -- sum(clients) as clients_test,
    sum(clients0) * ret * spends as spends,
    sum(clients) * spends as spends_test
from 
    $test as test
join 
    $ret_control as ret_control
    on test.epoch = ret_control.epoch
group by    
    ret_control.epoch as epoch,
    ret_control.ret as ret,
    test.spends as spends
;

INSERT INTO  `//home/geoadv/geosmb/analytics/miankova/exp/spends_test` WITH TRUNCATE 
SELECT 
    2 as sort,
    'Открутки при выживаемости как в контроле (без учета промокодов)' as param,
    Math::Round(sum(spends), 0) as num
from 
    $spends
union all

SELECT 
    1 as sort,
    'Реальные открутки в тесте (без учета промокодов)' as param,
    Math::Round(sum(spends_test), 0) as num
from 
    $spends
union all
SELECT 
    3 as sort,
    'Полученная выгода' as param,
    Math::Round(sum(spends_test) - sum(spends), 0)  as num
from 
    $spends
union all

SELECT 
    4 as sort,
    'Вознаграждение %' as param,
    Math::Round(sum(proc_prize*money/100), 0) as num
from 
    `//home/geoadv/geosmb/analytics/amocrm/prod/money_login`
union all

SELECT 
    5 as sort,
    'Вознаграждение фикс' as param,
    Math::Round(sum(fix_pay_flg*10000), 0) as num
from 
    `//home/geoadv/geosmb/analytics/amocrm/prod/money_login`
union all

SELECT 
    6 as sort,
    'Вознаграждение всего' as param,
    Math::Round(sum(fix_pay_flg*10000)+sum(proc_prize*money/100), 0) as num
from 
    `//home/geoadv/geosmb/analytics/amocrm/prod/money_login`
union all

SELECT 
    7 as sort,
    'Открутки с учетом промокодов' as param,
    Math::Round(sum(`money`), 0)  as num
from 
    `//home/geoadv/geosmb/analytics/amocrm/prod/money_login`
;
