use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$clients = 
SELECT 
    client_id as clientid, 
    case
        when `is_geo` = 1 then 'Контроль Я.Бизнес'
        else 'Контроль'
    end as group_type,
    '1970-01-01' as create_dt,
    `min_total_sum`,
    `min_dt`
from 
    `//home/smbsales/h2s/2.0/control_group_for_agency` as groups
where 
    `is_agency_exp` = 0
    and client_id not in 
    (select distinct clientid from`//home/geoadv/geosmb/analytics/amocrm/prod/logins`
            where login = login_from_amo)
    and `min_total_sum` >= 10000
union all 

(select 
    distinct clientid ,
    'Тест' as group_type,
    create_dt
from`//home/geoadv/geosmb/analytics/amocrm/prod/logins`
    where login = login_from_amo)
;



$base = 
SELECT 
    groups.clientid as clientid,
    groups.group_type as group_type,
    sum(cd.money_wo_discount) as money,
    sum(cd.money) as spends,
    min(day) over (partition by groups.clientid) as min_day,
    day
from
    $clients as groups
left join
    `//statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers` as cd
    on cd.clientid = groups.clientid
where  
    cd.money > 0 
    and cd.scale = 'days'
    and cd.currency = 'rur'
    and cd.product = 'Общая выручка'
    and cd.product_1 like 'Директ%'
    and cd.day >= groups.create_dt
group by 
    cd.day as day,
    groups.group_type,
    groups.clientid
;

$base_clients = 
select 
    distinct clientid, 
    min_day,
    group_type
from 
    $base
;


$new_money0 = 
    SELECT 
    clientid,
    dt,
    min_day,
    group_type,
    count(balance.total_sum) as count_new_money,
    sum(balance.total_sum) as total_sum,

    from
    `//home/smbsales/h2s/2.0/control_group_for_agency_balance_raw` as balance
    right join
        $base_clients as groups
    on balance.client_id = groups.clientid
    group by 
        balance.client_id as clientid,
        balance.dt as dt,
        groups.group_type as group_type,
        groups.min_day as min_day
;

$date_parse = DateTime::Parse("%Y-%m-%d");
$date_format = DateTime::Format("%Y-%m-%d");
$m_shift = ($a) -> {
return $date_format(DateTime::ShiftMonths($date_parse($a), -1))
};
$new_money = 
SELECT 
    clientid,
    min_day,
    dt,
    group_type,
    sum(count_new_money) as count_new_money,
    sum(total_sum) as total_sum

from 
    $new_money0
group by
    clientid,
    min_day,
    group_type,

    case 
        when cast(dt as string) <= min_day then $m_shift(min_day)
        else cast(dt as string)
    end as dt

;


$res = 
SELECT 
    coalesce(spends.clientid,new_money.clientid) as clientid,
    coalesce(spends.group_type, new_money.group_type) as group_type,
    coalesce(spends.money,0) as money,
    coalesce(spends.spends,0) as spends,
    coalesce(new_money.count_new_money, 0) as count_new_money,
    coalesce(spends.min_day, new_money.min_day) as min_day,
    coalesce(spends.day, cast(new_money.dt as string)) as day,
    coalesce(new_money.total_sum, 0) as new_money
from
    $base as spends
full join
    $new_money as new_money
    on spends.clientid = new_money.clientid and spends.day = new_money.dt
;

INSERT INTO `//home/geoadv/geosmb/analytics/miankova/exp/exp_groups_days1` WITH TRUNCATE 
select *
from 
    $res
;

