use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$limits_clients = 
select 
    distinct `client_id`
from 
    `//home/geo-analytics/miankova/overdraft/prepayments/limits_clients_all`
;

$epoch = ($today, $start_day) -> {
    return 
        -- case 
        -- when $today<$start_day then -1
        -- else
        DateTime::ToDays(cast($today as date) - cast($start_day as Date))/ 30
    -- end
};

$clients = 
SELECT
    `client_id`,
    `id`, 
    `receipt_date`, 
    `receipt_sum_new`, 
    `statusBalanceBanned`, 
    `total_act_sum`, 
    `consume_sum`,
    `date`,
    min(`date`) over (partition by client_id) as min_over_date 
from 
    `//home/geo-analytics/miankova/overdraft/additional_money` as m
where 
    client_type = 'Клиент'
    and overdraft_type = 'simple'
;

$clients_min_over = 
select 
    distinct client_id, 
    min_over_date 
from 
    $clients 
;



$money_groups = 
select 
    clientid as client_id, 
    avg(money) as avg_money_2021
from
(select 
    `clientid`,
    month, 
    sum(`money`) as money
from
    `//statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers` 
where
    scale = 'months'
    -- and money > 1000
    and month like '2021-1%'
    -- and first_day >= '2021-01-01'
    -- and first_day <= '2021-12-01'
    and currency = 'rur'
    and product = 'Общая выручка'
    and product_1 like 'Директ%'
    and (clientid in $limits_clients
    or clientid in (select distinct client_id from $clients))
group by 
    clientid, 
    month)
group by 
    clientid
;



$cd_money00 = 
select 
    `clientid` as client_id,
    day, 
    money
from 
        `//statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers` 
where
        scale = 'days'
        -- and money > 0
        -- and (day like '2022%' or day like '2021%')
        -- and first_day >= '2021-01-01'
        -- and first_day <= '2021-12-01'
        and currency = 'rur'
        and product = 'Общая выручка'
        and product_1 like 'Директ%'
        and (clientid in $limits_clients
        or clientid in (select distinct client_id from $clients))
;

$clients_money = 
SELECT 
    client_id, 
    epoch, 
    min_over_date,
    sum(money) as money
from 
    $cd_money00 as money
join 
    $clients_min_over as cl 
    using(client_id)
group by 
    $epoch(money.`day`, cl.min_over_date) as epoch,
    money.client_id as client_id, 
    cl.min_over_date as min_over_date
;

$first_day = 
SELECT 
    client_id, 
    min(day) as client_first_date
from 
    $cd_money00
where money > 0
group by 
    client_id 
;

$res = 
SELECT 
    client_id,
    statusBalanceBanned,
    client_first_date,
    epoch,
    min_over_date,
    count(id) as invoices,
    count_if(receipt_sum_new >= 0.9 * total_act_sum) as num_returned,
    sum(`receipt_sum_new`) as receipt_sum_new, 
    sum(total_act_sum) as total_act_sum, 
    sum(consume_sum) as consume_sum
from 
    $clients as clients
join 
    $first_day as fd 
    on clients.client_id = fd.client_id
group by 
    $epoch(clients.`date`, clients.min_over_date) as epoch,
    clients.client_id as client_id, 
    clients.statusBalanceBanned as statusBalanceBanned,
    fd.client_first_date as client_first_date, 
    clients.min_over_date as min_over_date
;

INSERT INTO 
     `//home/geo-analytics/miankova/overdraft/overdrafts_epochs`  
     WITH TRUNCATE 
select 
    coalesce(r.client_id, m.client_id) as client_id,
    coalesce(statusBalanceBanned, "No") as statusBalanceBanned,
    coalesce(r.client_first_date, fd.client_first_date) as client_first_date,
    coalesce(money_avgm.avg_money_2021, money_avg.avg_money_2021) as avg_money_2021,
    coalesce(r.epoch, m.epoch) as epoch,
    coalesce(r.min_over_date, m.min_over_date) as min_over_date,
    invoices,
    num_returned,
    receipt_sum_new, 
    total_act_sum, 
    consume_sum,
    coalesce(m.money, 0) as money
from 
    $clients_money as m
left join 
    $res as r
    on r.client_id = m.client_id and r.epoch = m.epoch
left join 
   $money_groups as money_avgm
   on money_avgm.client_id = m.client_id
left join 
   $money_groups as money_avg 
   on money_avg.client_id = r.client_id
left join 
    $first_day as fd 
    on fd.client_id = m.client_id;



$limits_epoch =
SELECT
    `client_id`, 
    epoch, 
    `min_count_date`,
    client_first_date,
    coalesce(max(`overdraft_lim`), 0) as overdraft_lim
from 
     `//home/geo-analytics/miankova/overdraft/prepayments/limits_clients_all` as l
join 
    $first_day as fd
    using(client_id)
-- where 
--     fd.`client_first_date` >= '2021-01-01'
group by 
    l.client_id as client_id, 
    l.min_count_date as min_count_date,
    fd.client_first_date as client_first_date,
    $epoch(l.`count_date`, l.`min_count_date`) as epoch
;

$clients_min_lim = 
select 
    distinct client_id, 
    min_count_date 
from 
     `//home/geo-analytics/miankova/overdraft/prepayments/limits_clients_all`  
;

$clients_money_lim = 
SELECT 
    client_id, 
    epoch, 
    sum(money) as money
from 
    $cd_money00 as money
join 
    $clients_min_lim as cl 
    using(client_id)
group by 
    $epoch(money.`day`, cl.min_count_date) as epoch,
    money.client_id as client_id
;

INSERT INTO 
    `//home/geo-analytics/miankova/overdraft/limits_epochs`  
     WITH TRUNCATE 
SELECT  
    coalesce(lim.client_id, mon.client_id) as client_id, 
    coalesce(mon.epoch,lim.epoch) as epoch, 
    mon.money as money, 
    `min_count_date`,
    client_first_date,
    overdraft_lim,
    money_avg.avg_money_2021 as avg_money_2021
from 
    $limits_epoch as lim
right join 
    $clients_money_lim as mon 
    on lim.client_id = mon.client_id and lim.epoch = mon.epoch
join 
   $money_groups as money_avg 
   on money_avg.client_id = lim.client_id
;

$res0 = 
SELECT 
    lim.*, 
    null as `consume_sum`, 
    null as `invoices`, 
    null as `min_over_date`, 
    null as `num_returned`, 
    null as `receipt_sum_new`, 
    "No" as `statusBalanceBanned`, 
    null as `total_act_sum`,
    true as flg_used_over
from 
    `//home/geo-analytics/miankova/overdraft/limits_epochs`  as lim
where 
    client_id not in
     (select distinct client_id from `//home/geo-analytics/miankova/overdraft/overdrafts_epochs`)
union all

select 
    e.*, 
    null as `min_count_date`, 
    null as `overdraft_lim`, 
    false as flg_used_over
from 
    `//home/geo-analytics/miankova/overdraft/overdrafts_epochs`  as e
;


PRAGMA AnsiInForEmptyOrNullableItemsCollections;
INSERT INTO `//home/geo-analytics/miankova/overdraft/epochs` WITH TRUNCATE 
select 
    r.*, 
    cl.money as money_epoch__1
from 
    $res0 as r
join
    (select 
        distinct 
            client_id,
            money
        from $res0 
        where epoch = 0
    ) as cl 
    using(client_id)
