use hahn;

$res=
select 
    min_month,
    epoch,
    month,
    operator_role,
    operator_and_tier,
    tier,

    start_1_mnth_money_category,
    start_3_mnth_money_category,
    start_12_mnth_money_category,

    start_year_category,
    industry, 
    product,

    -- суммарная выручка агентства за месяц
    sum(all_money) as money,             
    count(distinct clientid) as epoch_size, 
    count(distinct agency_id) as epoch_size_agency,
    -- Кол-во клиентов в первом месяце
    max(count(distinct clientid)) 
        over 
        (partition by tier, min_month, operator_role, start_1_mnth_money_category, start_3_mnth_money_category,
        start_12_mnth_money_category, product, industry)  
    as epoch_zero


from `//home/geoadv/geosmb/analytics/miankova/cd_all_avg_money`  as all_m
WHERE min_month >= '2018-01-01'
-- and epoch <= 12
group by  
    month, tier, min_month, operator_role, operator_and_tier, start_year_category,
    start_1_mnth_money_category, start_3_mnth_money_category, start_12_mnth_money_category, 
    epoch, industry, product
;


INSERT INTO `//home/geoadv/geosmb/analytics/miankova/cd_all_avg_money_res` WITH TRUNCATE
select * from $res;
