USE hahn;
$path = "home/geo-analytics/serge-ssk/agency_certification/agency_certification";
$path_geo_product = "home/geoadv/geoproduct/money/revenue";
$path_agencies_ids_names = "home/geoadv/geoproduct/intermediate/agencies_dash/agencies_ids_names";
$path_agency_cabinet = "home/geodisplay/analytics/reports/agency_cabinet_stat_monthly_with_balance_difference";

--Geo Product (Подписка)

-- Сопоставление клиентов и агентств из геопродукта (подписки)
$select_for_geo_product = SELECT
    SUBSTRING(a.dt, 0, 8) || "01" AS Month,
    a.client_id AS ClientID,
    a.sum_rub AS SumRub,
    a.geo_campaign_id AS GeoCampaignID,
    b.agency_id AS AgencyID,
    b.agency_name AS AgencyName
FROM $path_geo_product AS a

INNER JOIN

$path_agencies_ids_names AS b

ON a.client_id == b.balance_client_id;

-- Считаем для каждого месяца и каждого агентства количество активных РК и ежемесячные открутки
$select_for_window_function_geo_product = SELECT
    Month,
    AgencyID,
    AgencyName,
    COUNT(DISTINCT GeoCampaignID) AS CountActivityCampaignGeoProduct,
    SUM(SumRub) AS SumMoneyGeoProduct
FROM $select_for_geo_product
WHERE
    AgencyID IS NOT NULL
GROUP BY Month, AgencyID, AgencyName;

-- Считаем минимальный месяц, когда у агентства появились открутки по подписке
$select_min_month_geo_product = SELECT
    AgencyID AS AgencyID,
    MIN(CAST(SUBSTRING(Month, 0, 4) || SUBSTRING(Month, 5, 2) || SUBSTRING(Month, 8, 2) AS Int32)) AS MinMonthGeoProduct
FROM $select_for_window_function_geo_product
GROUP BY AgencyID;

--Geo Media (Геомедийка)
$select_for_geo_media = SELECT
    fielddate AS Month,
    agency_id AS AgencyID,
    agency_name AS AgencyName,
    client_id AS ClientID,
    amount_sum AS AmountSum,
    order_id AS OrderID,
FROM $path_agency_cabinet;

-- Считаем для каждого месяца и каждого агентства кол-во активных РК и ежемесячные открутки
$select_for_window_function_geo_media = SELECT
    Month,
    AgencyID,
    AgencyName,
    COUNT(DISTINCT OrderID) AS CountOrdersGeoMedia,
    SUM(AmountSum) AS SumMoneyGeoMedia
FROM $select_for_geo_media
WHERE
    AgencyID IS NOT NULL
GROUP BY Month, AgencyID, AgencyName;

-- Считаем минимальный месяц, когда у агентства появились открутки по геомедийке
$select_min_month_geo_media = SELECT
    AgencyID AS AgencyID,
    MIN(CAST(SUBSTRING(Month, 0, 4) || SUBSTRING(Month, 5, 2) || SUBSTRING(Month, 8, 2) AS Int32)) AS MinMonthGeoMedia
FROM $select_for_window_function_geo_media
GROUP BY AgencyID;

-- Объединение таблиц для гео-продукта (подписки) и геомедийки
$select_product_media_for_window_function = SELECT
    a.Month ?? b.Month AS Month,
    a.AgencyID ?? b.AgencyID AS AgencyID,
    a.AgencyName ?? b.AgencyName AS AgencyName,
    a.CountActivityCampaignGeoProduct ?? 0 AS CountActivityCampaignGeoProduct,
    CAST((a.SumMoneyGeoProduct ?? 0) AS Int32) AS SumMoneyGeoProduct,
    b.CountOrdersGeoMedia ?? 0 AS CountOrdersGeoMedia,
    CAST((b.SumMoneyGeoMedia ?? 0) AS Int32) AS SumMoneyGeoMedia,
FROM $select_for_window_function_geo_product AS a

FULL JOIN

$select_for_window_function_geo_media AS b

ON a.Month == b.Month AND a.AgencyID == b.AgencyID;


-- Создаем дополнительную таблицу всех месяцев и всех агентств для подписки и геомедийки

-- Рассматриваем дополнительную таблицу всех месяцев для подписки
$aux_yt_for_window_geo_product_month = SELECT
DISTINCT Month AS AllMonth
FROM $select_for_geo_product;

-- Рассматриваем дополнительную таблицу всех агентств для подписки
$aux_yt_for_window_geo_product_agency = SELECT
DISTINCT AgencyID AS AllAgencyID,
AgencyName AS AllAgencyName
FROM $select_for_geo_product;

-- Рассматриваем дополнительную таблицу всех месяцев для геомедийки
$aux_yt_for_window_geo_media_month = SELECT
DISTINCT Month AS AllMonth
FROM $select_for_geo_media;

-- Рассматриваем дополнительную таблицу всех агентств для геомедийки
$aux_yt_for_window_geo_media_agency = SELECT
DISTINCT AgencyID AS AllAgencyID,
AgencyName AS AllAgencyName
FROM $select_for_geo_media;

-- Создаем таблицу всех месяцев
$aux_yt_all_month = SELECT
a.AllMonth ?? b.AllMonth AS AllMonth
FROM $aux_yt_for_window_geo_product_month AS a

FULL JOIN

$aux_yt_for_window_geo_media_month AS b
ON a.AllMonth == b.AllMonth;

-- Создаем таблицу всех агентств
$aux_yt_all_agency = SELECT
a.AllAgencyID ?? b.AllAgencyID AS AllAgencyID,
a.AllAgencyName ?? b.AllAgencyName AS AllAgencyName
FROM $aux_yt_for_window_geo_product_agency AS a

FULL JOIN

$aux_yt_for_window_geo_media_agency AS b
ON a.AllAgencyID == b.AllAgencyID;


-- Рассматриваем дополнительную таблицу, которая является кросс джоином всех месяцев и всех агентств
$aux_yt_month_agency = SELECT
a.AllMonth AS AllMonth,
b.AllAgencyID AS AllAgencyID,
b.AllAgencyName AS AllAgencyName
FROM $aux_yt_all_month AS a

CROSS JOIN

$aux_yt_all_agency AS b;


-- Вставляем пропущенные месяцы и агентства
$select_product_media_for_window_function_full = SELECT
    a.Month ?? b.AllMonth AS Month,
    a.AgencyID ?? b.AllAgencyID AS AgencyID,
    a.AgencyName ?? b.AllAgencyName AS AgencyName,
    a.CountActivityCampaignGeoProduct ?? 0 AS CountActivityCampaignGeoProduct,
    a.CountOrdersGeoMedia ?? 0 AS CountOrdersGeoMedia,
    a.SumMoneyGeoProduct ?? 0 AS SumMoneyGeoProduct,
    a.SumMoneyGeoMedia ?? 0 AS SumMoneyGeoMedia
FROM $select_product_media_for_window_function AS a

RIGHT JOIN

$aux_yt_month_agency AS b
ON a.Month == b.AllMonth AND a.AgencyID == b.AllAgencyID;


-- Добавляем в эту полную таблицу информацию о первом месяце ненулевых откруток для каждого агенства по подписке
$select_product_media_for_window_function_full_with_min_month_geo_product = SELECT
    a.Month AS Month,
    a.AgencyID AS AgencyID,
    a.AgencyName AS AgencyName,
    a.CountActivityCampaignGeoProduct AS CountActivityCampaignGeoProduct,
    a.CountOrdersGeoMedia AS CountOrdersGeoMedia,
    a.SumMoneyGeoProduct AS SumMoneyGeoProduct,
    a.SumMoneyGeoMedia AS SumMoneyGeoMedia,
    SUBSTRING(CAST(b.MinMonthGeoProduct AS String), 0, 4) || "-" || SUBSTRING(CAST(b.MinMonthGeoProduct AS String), 4, 2) || "-" || SUBSTRING(CAST(b.MinMonthGeoProduct AS String), 6, 2) ?? "3000-01-01" AS MinMonthGeoProduct
FROM $select_product_media_for_window_function_full AS a

LEFT JOIN

$select_min_month_geo_product AS b

ON a.AgencyID == b.AgencyID;

-- Добавляем в эту полную таблицу информацию о первом месяце ненулевых откруток для каждого агенства по геомедийке
$select_product_media_for_window_function_full_with_min_month = SELECT
    a.Month AS Month,
    a.AgencyID AS AgencyID,
    a.AgencyName AS AgencyName,
    a.CountActivityCampaignGeoProduct AS CountActivityCampaignGeoProduct,
    a.CountOrdersGeoMedia AS CountOrdersGeoMedia,
    a.SumMoneyGeoProduct AS SumMoneyGeoProduct,
    a.SumMoneyGeoMedia AS SumMoneyGeoMedia,
    a.MinMonthGeoProduct AS MinMonthGeoProduct,
    SUBSTRING(CAST(b.MinMonthGeoMedia AS String), 0, 4) || "-" || SUBSTRING(CAST(b.MinMonthGeoMedia AS String), 4, 2) || "-" || SUBSTRING(CAST(b.MinMonthGeoMedia AS String), 6, 2) ?? "3000-01-01" AS MinMonthGeoMedia
FROM $select_product_media_for_window_function_full_with_min_month_geo_product AS a

LEFT JOIN

$select_min_month_geo_media AS b

ON a.AgencyID == b.AgencyID;

-- Вычисляем сумму откруток за 6 и 12 месяцев
$select_sum_product_media = SELECT
    Month AS Month,
    AgencyID AS AgencyID,
    AgencyName AS AgencyName,
    CountActivityCampaignGeoProduct AS CountActivityCampaignGeoProduct,
    SUM(SumMoneyGeoProduct) OVER w_geo_product AS SumForAvgOfMoneyGeoProduct,
    SumMoneyGeoProduct AS SumMoneyGeoProduct,
    CountOrdersGeoMedia AS CountOrdersGeoMedia,
    SUM(SumMoneyGeoMedia) OVER w_geo_media AS SumForAvgOfMoneyGeoMedia,
    SumMoneyGeoMedia AS SumMoneyGeoMedia,
    MinMonthGeoProduct AS MinMonthGeoProduct,
    MinMonthGeoMedia AS MinMonthGeoMedia
FROM $select_product_media_for_window_function_full_with_min_month
WINDOW
w_geo_product AS (
    PARTITION BY AgencyID
    ORDER BY Month
    ROWS BETWEEN 5 PRECEDING AND 0 FOLLOWING
),
w_geo_media AS (
    PARTITION BY AgencyID
    ORDER BY Month
    ROWS BETWEEN 11 PRECEDING AND 0 FOLLOWING
);

-- Вычисляем средние за 6 и 12 месяцев открутки и записываем результат
INSERT INTO $path WITH TRUNCATE
SELECT
    Month AS Month,
    AgencyID AS AgencyID,
    AgencyName AS AgencyName,
    CountActivityCampaignGeoProduct AS CountActivityCampaignGeoProduct,
    SumForAvgOfMoneyGeoProduct / MIN_OF(1 + 12 * (DateTime::GetYear(CAST(Month AS Date)) - DateTime::GetYear(CAST(MinMonthGeoProduct AS Date))) + DateTime::GetMonth(CAST(Month AS Date)) - DateTime::GetMonth(CAST(MinMonthGeoProduct AS Date)), 6) ?? 0 AS AvgOfMoneyGeoProduct,
    SumMoneyGeoProduct AS SumMoneyGeoProduct,
    CountOrdersGeoMedia AS CountOrdersGeoMedia,
    SumForAvgOfMoneyGeoMedia / MIN_OF(1 + 12 * (DateTime::GetYear(CAST(Month AS Date)) - DateTime::GetYear(CAST(MinMonthGeoMedia AS Date))) + DateTime::GetMonth(CAST(Month AS Date)) - DateTime::GetMonth(CAST(MinMonthGeoMedia AS Date)), 12) ?? 0 AS AvgOfMoneyGeoMedia,
    SumMoneyGeoMedia AS SumMoneyGeoMedia
FROM $select_sum_product_media
WHERE CAST(SUBSTRING(Month, 0, 4) AS Int32) >= 2020;