USE hahn;
$path = "home/geo-analytics/serge-ssk/revenue/total_revenue_2020";
INSERT INTO $path WITH TRUNCATE
SELECT
    period AS Month,
    SUM(money) AS money
FROM `//statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers`
WHERE
    scale == "months"
    AND product == "Общая выручка"
    AND period LIKE '2020%'
    AND money IS NOT NULL
GROUP BY period
ORDER BY Month;

$path = "home/geo-analytics/serge-ssk/revenue/total_revenue_2021";
INSERT INTO $path WITH TRUNCATE
SELECT
    period AS Month,
    SUM(money) AS money
FROM `//statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers`
WHERE
    scale == "months"
    AND product == "Общая выручка"
    AND period LIKE '2021%'
    AND money IS NOT NULL
GROUP BY period
ORDER BY Month;

$path = "home/geo-analytics/serge-ssk/revenue/total_revenue_detailed_2020";
INSERT INTO $path WITH TRUNCATE
SELECT
    period as Month,
    CASE operator_role
        WHEN "elama" THEN "Елама"
        WHEN "agregator" THEN "Агрегаторы"
        WHEN "agency" THEN "Агентства"
        WHEN "pseudo_agency" THEN "Самоходные агентства"
        WHEN "freelancer_official" THEN "Официальные фрилансеры"
        WHEN "freelancer_unofficial" THEN "Неофициальные фрилансеры"
        ELSE "Прямые клиенты"
    END AS TypeClient,
    SUM(money) AS money
FROM `//statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers`
WHERE
    scale == "months"
    AND product == "Общая выручка"
    AND period LIKE '2020%'
    AND money IS NOT NULL
GROUP BY period, operator_role
ORDER BY Month;

$path = "home/geo-analytics/serge-ssk/revenue/total_revenue_detailed_2021";
INSERT INTO $path WITH TRUNCATE
SELECT
    period as Month,
    CASE operator_role
        WHEN "elama" THEN "Елама"
        WHEN "agregator" THEN "Агрегаторы"
        WHEN "agency" THEN "Агентства"
        WHEN "pseudo_agency" THEN "Самоходные агентства"
        WHEN "freelancer_official" THEN "Официальные фрилансеры"
        WHEN "freelancer_unofficial" THEN "Неофициальные фрилансеры"
        ELSE "Прямые клиенты"
    END AS TypeClient,
    SUM(money) AS money
FROM `//statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers`
WHERE
    scale == "months"
    AND product == "Общая выручка"
    AND period LIKE '2021%'
    AND money IS NOT NULL
GROUP BY period, operator_role
ORDER BY Month;

$path = "home/geo-analytics/serge-ssk/revenue/total_activity_clients_2020";
INSERT INTO $path WITH TRUNCATE
SELECT
    period as Month,
    COUNT(DISTINCT(clientid)) AS CountActivityClients
FROM `//statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers`
WHERE
    scale == "months"
    AND product == "Общая выручка"
    AND period LIKE '2020%'
    AND money IS NOT NULL
    AND money > 1000.0
GROUP BY period
ORDER BY Month;

$path = "home/geo-analytics/serge-ssk/revenue/total_activity_clients_2021";
INSERT INTO $path WITH TRUNCATE
SELECT
    period as Month,
    COUNT(DISTINCT(clientid)) AS CountActivityClients
FROM `//statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers`
WHERE
    scale == "months"
    AND product == "Общая выручка"
    AND period LIKE '2021%'
    AND money IS NOT NULL
    AND money > 1000.0
GROUP BY period
ORDER BY Month;

$path = "home/geo-analytics/serge-ssk/revenue/tier_revenue_2020";
$select_aux = SELECT
    period AS Month,
    CASE
        WHEN curr_reporting_tier LIKE '%SMB%' THEN "T3"
        WHEN curr_reporting_tier LIKE '%SB%' THEN "T4"
        ELSE "Other"
    END AS ClientTier,
    SUM(money) AS money
FROM `//statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers`
WHERE
    scale == "months"
    AND product == "Общая выручка"
    AND period LIKE '2020%'
    AND money IS NOT NULL
GROUP BY period, curr_reporting_tier;

INSERT INTO $path WITH TRUNCATE
SELECT
    Month AS Month,
    ClientTier AS ClientTier,
    SUM(money) AS money
FROM $select_aux
GROUP BY Month, ClientTier
ORDER BY Month;

$path = "home/geo-analytics/serge-ssk/revenue/tier_revenue_2021";
$select_aux = SELECT
    period AS Month,
    CASE
        WHEN curr_reporting_tier LIKE '%SMB%' THEN "T3"
        WHEN curr_reporting_tier LIKE '%SB%' THEN "T4"
        ELSE "Other"
    END AS ClientTier,
    SUM(money) AS money
FROM `//statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers`
WHERE
    scale == "months"
    AND product == "Общая выручка"
    AND period LIKE '2021%'
    AND money IS NOT NULL
GROUP BY period, curr_reporting_tier;

INSERT INTO $path WITH TRUNCATE
SELECT
    Month AS Month,
    ClientTier AS ClientTier,
    SUM(money) AS money
FROM $select_aux
GROUP BY Month, ClientTier
ORDER BY Month;

$path = "home/geo-analytics/serge-ssk/revenue/tier_count_activity_clients_2020";
$select_aux = SELECT
    period AS Month,
    CASE
        WHEN curr_reporting_tier LIKE '%SMB%' THEN "T3"
        WHEN curr_reporting_tier LIKE '%SB%' THEN "T4"
        ELSE "Other"
    END AS ClientTier,
    COUNT(DISTINCT(clientid)) AS TierCountActivityClients
FROM `//statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers`
WHERE
    scale == "months"
    AND product == "Общая выручка"
    AND period LIKE '2020%'
    AND money IS NOT NULL
    AND money > 1000.0
GROUP BY period, curr_reporting_tier;

INSERT INTO $path WITH TRUNCATE
SELECT
    Month AS Month,
    ClientTier AS ClientTier,
    SUM(TierCountActivityClients) AS TierCountActivityClients
FROM $select_aux
GROUP BY Month, ClientTier
ORDER BY Month;

$path = "home/geo-analytics/serge-ssk/revenue/tier_count_activity_clients_2021";
$select_aux = SELECT
    period AS Month,
    CASE
        WHEN curr_reporting_tier LIKE '%SMB%' THEN "T3"
        WHEN curr_reporting_tier LIKE '%SB%' THEN "T4"
        ELSE "Other"
    END AS ClientTier,
    COUNT(DISTINCT(clientid)) AS TierCountActivityClients
FROM `//statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers`
WHERE
    scale == "months"
    AND product == "Общая выручка"
    AND period LIKE '2021%'
    AND money IS NOT NULL
    AND money > 1000.0
GROUP BY period, curr_reporting_tier;

INSERT INTO $path WITH TRUNCATE
SELECT
    Month AS Month,
    ClientTier AS ClientTier,
    SUM(TierCountActivityClients) AS TierCountActivityClients
FROM $select_aux
GROUP BY Month, ClientTier
ORDER BY Month;
