#include <mapreduce/yt/interface/client.h>
#include <mapreduce/yt/interface/operation.h>

const TString ClusterName = "hahn";
const TString ResultTable = "//home/search-functionality/nikola-erm/tv_sum";
const TVector<TString> InputTables = {
    "//home/search-functionality/nikola-erm/tv_shows_mob_2018-04-02",
    "//home/search-functionality/nikola-erm/tv_shows_mob_2018-04-03",
    "//home/search-functionality/nikola-erm/tv_shows_mob_2018-04-04",
    "//home/search-functionality/nikola-erm/tv_shows_mob_2018-04-05",
    "//home/search-functionality/nikola-erm/tv_shows_mob_2018-04-06",
    "//home/search-functionality/nikola-erm/tv_shows_mob_2018-04-07",
    "//home/search-functionality/nikola-erm/tv_shows_mob_2018-04-08",
    "//home/search-functionality/nikola-erm/tv_shows_mob_2018-04-09",
    "//home/search-functionality/nikola-erm/tv_shows_mob_2018-04-10",
    "//home/search-functionality/nikola-erm/tv_shows_mob_2018-04-11",
    "//home/search-functionality/nikola-erm/tv_shows_mob_2018-04-12",
    "//home/search-functionality/nikola-erm/tv_shows_mob_2018-04-13",
    "//home/search-functionality/nikola-erm/tv_shows_mob_2018-04-14"
};

typedef NYT::TTableReader<NYT::TNode> TTableReader;
typedef NYT::TTableWriter<NYT::TNode> TTableWriter;

class TMyMapper : public NYT::IMapper<TTableReader, TTableWriter> {
private:
    THashMap<TString, size_t> Count[4];
public:
    void Do(TTableReader* reader, TTableWriter* writer) override {
        Y_UNUSED(writer);
        for (; reader->IsValid(); reader->Next()) {
            const auto& node = reader->GetRow();
            const bool click = node["Click"].AsBool();
            const bool wiz = node["WizShown"].AsBool();
            const TString& testId = node["TestID"].AsString();
            const size_t index = (wiz ? 2 : 0) + (click ? 1 : 0);
            ++Count[index][testId];
        }
    }
    void Finish(TTableWriter* writer) override {
        for (size_t i = 0; i < 4; ++i) {
            for (const auto& kv : Count[i]) {
                writer->AddRow(NYT::TNode()("Mask", i)("TestID", kv.first)("Cnt", kv.second));
            }
        }
    }
};

class TMyReducer : public NYT::IReducer<TTableReader, TTableWriter> {
private:
    THashMap<TString, size_t> Count[4];
public:
    void Do(TTableReader* reader, TTableWriter* writer) override {
        Y_UNUSED(writer);
        for (; reader->IsValid(); reader->Next()) {
            const auto& node = reader->GetRow();
            Count[node["Mask"].AsUint64()][node["TestID"].AsString()] += node["Cnt"].AsUint64();
        }
    }
    void Finish(TTableWriter* writer) override {
        for (size_t mask = 0; mask < 4; ++mask) {
            const bool wiz = 2 & mask;
            const bool click = 1 & mask;
            for (const auto& kv : Count[mask]) {
                writer->AddRow(NYT::TNode()("TestID", kv.first)("WizShown", wiz)("Click", click)("Cnt", kv.second));
            }
        }
    }
};

REGISTER_MAPPER(TMyMapper);
REGISTER_REDUCER(TMyReducer);

int main(int argc, const char* argv[]) {
    NYT::Initialize(argc, argv);
    auto ytClient = NYT::CreateClient(ClusterName);
    NYT::TMapReduceOperationSpec mrSpec;
    for (const TString& inputTable : InputTables) {
        mrSpec.AddInput<NYT::TNode>(inputTable);
    }
    mrSpec.AddOutput<NYT::TNode>(ResultTable)
        .ReduceBy("TestID");
    ytClient->MapReduce(mrSpec, new TMyMapper(), new TMyReducer());
    return 0;
}
