#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import division
import sys
import libra
import argparse
import yt.wrapper as yt
import json

def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("--server", dest="server", help="mapreduce server",default='hahn.yt.yandex.net:80', required=False)
    parser.add_argument("--bs", dest="blockstat", help="path to blockstat.dict",default='blockstat.dict', required=False)
    return parser

def extract_old(key,recs):
    uid = key
    try:
        session = libra.ParseSession(recs, './blockstat.dict')
    except:
        return
    for request in session:
        result = {}
        if not (request.IsA("TYandexWebRequest") or request.IsA("TMobileYandexWebRequest") or request.IsA("TTouchYandexWebRequest")):
            continue
        result['Query'] = request.Query.lower()
        result['TestID'] = ""
        #e_ids = ['69113', '69114']
        #e_ids = ['73589', '73593', '73596', '73597', '73599']
        e_ids = ['73577', '73578', '73579', '73580', '73582', '73585', '73587']
        for test_info in request.GetTestInfo():
            if test_info.TestID in e_ids:
                result['TestID'] = test_info.TestID
        if not result['TestID']:
            continue
        toShow = False
        for block in request.GetMainBlocks():
            res = block.GetMainResult()
            if not res:
                continue
            if block.Position != 0:
                continue
            if not res.IsA("TBlenderWizardResult") and not res.IsA("TWizardResult"):
                continue
            if  "snippet/tv/online/channel" in res.Path:
                result['Path'] = res.Path
                toShow = True
        result['Click'] = False;
        if toShow:
            for c in request.GetClicks():
                if '254.273.1273.1345' in c.Path:
                    result['Click'] = True
                    break
        result['WizShown'] = toShow;
        yield result;

# def extract(key,recs):
    # uid = key
    # try:
        # session = libra.ParseSession(recs, './blockstat.dict')
    # except:
        # return
    # for request in session:
        # result = {}
        # if not request.IsA('TYandexWebRequest'):
            # continue
        # result['Query'] = request.Query.lower()
        # result['TestID'] = []
        # e_ids = ['69113', '69114']
        # for test_info in request.GetTestInfo():
            # if test_info.TestID in e_ids:
                # result['TestID'].append(test_info.TestID)
        # if not result['TestID']:
            # continue
        # for block in request.GetMainBlocks():
            # res = block.GetMainResult()
            # if not res.IsA("TWebResult"):
                # continue
            # if "Rule" in res.Markers and res.Markers["Rule"] == "TVTranslations":
                # result['ClickCount'] = len(res.GetClicks())
                # yield result

def main():
    args = HandleOption().parse_args()
    yt.update_config({'proxy': {'url': args.server}})
    #days = ['2018-03-05', '2018-03-06', '2018-03-07', '2018-03-08', '2018-03-09', '2018-03-10', '2018-03-11']
    #days = ['2018-03-11']
    #days = ['2018-04-02', '2018-04-03', '2018-04-04', '2018-04-05', '2018-04-06', '2018-04-07', '2018-04-08', '2018-04-09', '2018-04-10', '2018-04-11', '2018-04-12', '2018-04-13', '2018-04-14']
    days = ['2018-04-10', '2018-04-11', '2018-04-12', '2018-04-13', '2018-04-14']
    for day in days:
        usersessions = '//user_sessions/pub/search/daily/' + day + '/clean'
        #usersessions = '//user_sessions/pub/search/fast/1520809200/clean'
        restable = '//home/search-functionality/nikola-erm/tv_shows_mob_' + day
        if not yt.exists(restable):
            yt.create_table(path = restable, recursive = True)
        yt.run_reduce(extract_old,
                      source_table = usersessions,
                      destination_table = restable,
                      local_files = [args.blockstat],
                      spec = {'data_size_per_job': 16000000000, 'reducer': {'memory_limit': 2036870912}},
                      reduce_by = 'key')

if __name__ == '__main__':
    main()
