from yql.typing import *


def deep_search(
        input_list: List[Tuple[Optional[String], Optional[String], Optional[String]]],
        id_focus: Optional[String] = None) -> List[Struct['id': Optional[String], 'hierarchy': Optional[List[Optional[String]]]]]:
    def get_all_children(id, lst):
        def get_next_children(tpl_lst):
            return [l for tl in tpl_lst for l in lst if l[1] == tl[0]]

        for v in lst:
            if v[0] == id:
                children_list = [v]
                break
        try:
            ch_next = get_next_children(children_list)
        except UnboundLocalError:
            return -1

        while len(ch_next) > 0:
            [children_list.append(ch) for ch in ch_next]
            ch_next = get_next_children(ch_next)
        return children_list

    def get_elem_tree(elem):
        def get_next(val):
            for r in input_list:
                if val == r[0]:
                    return r[2], r[1]  # leave after first reach

        elem_tree = {'id': elem[0], 'hierarchy': []}
        next_val = elem[2], elem[1]

        while next_val is not None:
            elem_tree['hierarchy'].insert(0, next_val[0])
            next_val = get_next(next_val[1]) if next_val[1] is not None else None
        return elem_tree

    actual_list = get_all_children(id_focus, input_list) if id_focus is not None else input_list
    if actual_list == -1:
        return [{'id': None, 'hierarchy': None}]
    return [get_elem_tree(rec) for rec in actual_list]
