#!/usr/bin/env python2
# coding=UTF-8
from mapreducelib import Record, MapReduce as MR
from mymrutils import *
import random
import libra

def main():

        MR.useDefaults(username='sitelinks', server='sakura.search.yandex.net:8013', verbose=True, files=['blockstat.dict'], mrExec='/home/pesitnikova/mapreduce/mapreduce')

        dst = 'pesitnikova/3528/2columnSitelinks'

	for src in ['user_sessions/{}'.format(d) for d in strdaterange((2015,11,2), (2015,11,9))]:
		MR.runReduce(processUSS, srcTable = src, dstTable = dst, appendMode=True)
		MR.runReduce(Summarizer(), srcTable = dst, dstTable = dst)
	MR.runMap(trans, srcTable = dst, dstTable = dst)
	MR.runReduce(Summarizer(), srcTable = dst, dstTable = dst)
	mrsort(dst)

def trans(rec):
	if rec.key.startswith('All_'):
		yield Record ('All', '', rec.value)
	else:
		yield Record (rec.key, '', rec.value)

def processUSS(key, recs):

        try:
                for req in libra.ParseSession(recs, 'blockstat.dict'):

                        if not req.IsA('TYandexWebRequest'):
                                continue

	 		yield Record('All_' + str(random.randrange(1000)), '', '1')

			colSl = [x for x in req.GetBSBlocks() if x.Path == '/snippet/bicolumn_sitelinks']
			if not colSl:
  				continue
			
			yield Record('2colSl', '', '1')	


	except (NameError, AttributeError, TypeError):
                raise
        except Exception:
                pass


if __name__ == '__main__':
        main()
