#!/usr/bin/env python2
# coding=UTF-8
from mapreducelib import Record, MapReduce as MR
from mymrutils import *
import random
import libra

def main():

        MR.useDefaults(username='sitelinks', server='sakura.search.yandex.net:8013', verbose=True, files=['blockstat.dict'], mrExec='/home/pesitnikova/mapreduce/mapreduce_new')

        DST = 'pesitnikova/clicks_bna_full'

	with mktmp() as tmp:
		for date in strdaterange((2015,7,28), (2015,8,3)):
			uss = 'user_sessions/{}'.format(date)
			MR.runReduce(processUSS, srcTable = uss, dstTable = tmp, appendMode=True)
			MR.runReduce(processUSSTouch, srcTable = uss, dstTable = tmp, appendMode=True)
		MR.runReduce(Summarizer(), srcTable = tmp, dstTable = DST)
		mrsort(DST)


def processUSS(key, recs):

        try:
                for req in libra.ParseSession(recs, 'blockstat.dict'):

                        if not req.IsA('TYandexWebRequest'):
                                continue

                        lang = req.ServiceDomRegion
                        if lang != 'ru':
                                continue

			yield Record('All', '', '1')			

			bnoBlocks = [x for x in req.GetBSBlocks() if x.Path == "/snippet/bno/link"]
			if not bnoBlocks:
				continue
			
			yield Record('BNA', '', '1')			

			hasBNAClicks = False
			hasNonBNAClicks = False
			for clck in req.GetClicks():
				for var in clck.GetVars():
					if var[0] == 'pos':
                                                pos = int(var[1][1:])
                                                if pos == 0:
                                                        hasBNAClicks = True
                                                        yield Record('BNA_result_clicks', '', '1')
                                                if pos > 0:
                                                        hasNonBNAClicks = True
                                                        yield Record('Non_BNA_clicks', '', '1')

                        if hasBNAClicks and not hasNonBNAClicks:
                                yield Record ('only_BNA_clicks', '', '1')
                        if hasBNAClicks and hasNonBNAClicks:
                                yield Record ('not_only_BNA_clicks', '', '1')
        
	except (NameError, AttributeError, TypeError):
                raise
        except Exception:
                pass

def processUSSTouch(key, recs):

        try:
                for req in libra.ParseSession(recs, 'blockstat.dict'):

                        if not req.IsA('TTouchYandexWebRequest'):
                                continue

                        lang = req.ServiceDomRegion
                        if lang != 'ru':
                                continue

                        yield Record('Touch_All', '', '1')

                        bnoBlocks = [x for x in req.GetBSBlocks() if x.Path == "/snippet/bno/link"]
                        if not bnoBlocks:
                                continue

                        yield Record('Touch_BNA', '', '1')

                        hasBNAClicks = False
                        hasNonBNAClicks = False
                        for clck in req.GetClicks():
                                for var in clck.GetVars():
                                        if var[0] == 'pos':
                                                pos = int(var[1][1:])
						if pos == 0:
                                                	hasBNAClicks = True
							yield Record('Touch_BNA_result_clicks', '', '1')
						if pos > 0:
                                                	hasNonBNAClicks = True
							yield Record('Touch_Non_BNA_clicks', '', '1')

			if hasBNAClicks and not hasNonBNAClicks:
				yield Record ('Touch_only_BNA_clicks', '', '1')
			if hasBNAClicks and hasNonBNAClicks:
				yield Record ('Touch_not_only_BNA_clicks', '', '1')				

        except (NameError, AttributeError, TypeError):
                raise
        except Exception:
                pass

if __name__ == '__main__':
        main()
