#!/usr/bin/env python2
# coding=UTF-8
from mapreducelib import Record, MapReduce as MR
from mymrutils import *
import random
import libra

def main():

        MR.useDefaults(username='sitelinks', server='sakura.search.yandex.net:8013', verbose=True, files=['blockstat.dict'], mrExec='/home/pesitnikova/mapreduce/mapreduce')

        DST = 'pesitnikova/more_touch'

        for src in ['user_sessions/{}'.format(d) for d in strdaterange((2015,12,18), (2015,12,25))]:

                MR.runReduce(getData, srcTable=src, dstTable=DST, appendMode=True)

        MR.runReduce(Summarizer(useSubkey = True), srcTable=DST, dstTable=DST)
	MR.runMap(trans, srcTable=DST, dstTable=DST)
        MR.runReduce(Summarizer(useSubkey = True), srcTable=DST, dstTable=DST)
	

def trans(rec):
	if rec.key.startswith('serps'):
		yield Record ('serps', rec.subkey, rec.value)
	elif rec.key.startswith('allsnippets'):
		yield Record ('allsnippets', rec.subkey, rec.value)
	elif rec.key.startswith('snippets_more'):
		yield Record ('snippets_more', rec.subkey, rec.value)
	elif rec.key.startswith('serp_more'):
                yield Record ('serp_more', rec.subkey, rec.value)
	else:
		yield Record (rec.key, rec.subkey, rec.value)


def getData(key, recs):

        try:

                for req in libra.ParseSession(recs, 'blockstat.dict'):

                        if not req.IsA('TTouchYandexWebRequest'):
                                continue

			if req.ServiceDomRegion == 'tr':
                		lang = 'tr'
            		elif req.ServiceDomRegion in ('ru', 'ua', 'by', 'kz'):
                		lang = 'kubr'
            		else:
                		continue
			
			yield Record('serps' + str(random.randrange(1000)), lang, '1')
			organic_web_results = set(x.GetMainResult().Position for x in req.GetMainBlocks() if x.GetMainResult().IsA("TWebResult"))
			yield Record('allsnippets' + str(random.randrange(1000)), lang, str(len(organic_web_results)))

			mores = [x for x in req.GetBSBlocks() if x.Path == "/web/item/more" ]
                        if not mores:
                                continue
			yield Record('snippets_more' + str(random.randrange(1000)), lang, str(len(mores)))
			
			isMore = False
			for more in mores:
				for v in more.GetVars():
					if v[0] == 'pos':
						pos = int(v[1][1:])
						if pos not in organic_web_results:
							continue
						if pos < 10:
							isMore = True
							yield Record(str(pos), lang, '1')
			if isMore:
				yield Record('serp_more' + str(random.randrange(1000)), lang, '1')


        except (NameError, AttributeError, TypeError):
                raise
        except Exception:
                pass

if __name__ == '__main__':
        main()
