#!/usr/bin/env python2
# coding=UTF-8
from mapreducelib import Record, MapReduce as MR
from mymrutils import *
import random
import libra

def main():

        MR.useDefaults(username='sitelinks', server='sakura.search.yandex.net:8013', verbose=True, files=['blockstat.dict'], mrExec='/home/pesitnikova/mapreduce/mapreduce')

        DST = 'pesitnikova/thumb_count_top10'

        for src in ['sample_by_yuid_1p/user_sessions/{}'.format(d) for d in strdaterange((2015,11,23), (2015,11,30))]:

                MR.runReduce(getData, srcTable=src, dstTable=DST, appendMode=True)

        MR.runReduce(Summarizer(), srcTable=DST, dstTable=DST)
        mrsort(DST)

def getData(key, recs):

        try:

                for req in libra.ParseSession(recs, 'blockstat.dict'):

                        if not req.IsA('TYandexWebRequest'):
                                continue

                        lang = req.ServiceDomRegion
                        if lang != 'ru':
                                continue

			yield Record ('All', '', '1')
 
			thumbs = [x for x in req.GetBSBlocks() if x.Path == "/snippet/video_snippet/site" ]
                        if not thumbs:
                                continue
			
#			yield Record ('thumbs', '', '1')
			isThumb = False	
			for thumb in thumbs:
				for v in thumb.GetVars():
					if v[0] == 'pos':
						pos = int(v[1][1:])
						if pos < 10:
							isThumb = True
				if isThumb:
					yield Record ('thumbs', '', '1')
					break
#				       		organic_web_results = [x.GetMainResult() for x in req.GetMainBlocks() if x.GetMainResult().IsA("TWebResult")]
#				       		res = [x for x in organic_web_results if x.Position == pos]
#						if not res:
#							continue
#						yield Record(res[0].Url, req.Query, '1')

        except (NameError, AttributeError, TypeError):
                raise
        except Exception:
                pass


if __name__ == '__main__':
        main()
