# coding: utf-8

from nile.api.v1 import (
    aggregators as na,
    filters as nf,
)

from analytics.plotter_lib.plotter import Plot, require, DATE_FORMAT


class WizardShows(Plot):
    @require('WebUserSessionsSearch.get_wizards_shows')
    def images_shows_queries(self, streams):
        return streams['WebUserSessionsSearch.get_wizards_shows'] \
            .filter(
                nf.equals('wizard', 'images')
            ) \
            .groupby('query') \
            .aggregate(
                count=na.count()
            )

    @require('WizardShows.images_shows_queries')
    def save_shows(self, streams):
        return streams['WizardShows.images_shows_queries'] \
            .top(100, by='count') \
            .sort('count') \
            .put('//tmp/{}_web_images_wizard_shows'.format(self.date.strftime(DATE_FORMAT)))
