# coding: utf-8

from nile.api.v1 import (
    Record,
)
from qb2.api.v1 import (
    typing as qt
)

from analytics.plotter_lib.plotter import Plot, require, DATE_FORMAT
from analytics.plotter_lib.utils import fromtimestamp
from analytics.plotter_example.plots.utils import get_request_ui


class WebUserSessionsSearch(Plot):
    def __init__(self, *args, **kwargs):
        super(WebUserSessionsSearch, self).__init__(*args, **kwargs)
        # Удаляем job из класса. Pickle не умеет nile job'ы прокидывать в yt операции
        self.job = None

    @require('user_sessions', layer='sessions', schema={
        'fielddate': qt.String,
        'ui': qt.String,
        'query': qt.String,
        'wizard': qt.String,
    })
    def get_wizards_shows(self, requests_container):
        for r in requests_container.GetRequests():
            if not r.IsA('TWebRequestProperties'):
                continue

            for b in r.GetMainBlocks() + r.GetParallelBlocks():
                res = b.GetMainResult()
                if res.IsA('TBlenderWizardResult'):
                    yield Record.from_dict({
                        'fielddate': fromtimestamp(int(r.Timestamp)).strftime(DATE_FORMAT),
                        'ui': get_request_ui(r),
                        'query': r.Query,
                        'wizard': res.Name,
                    })
