## Plotter — построитель графиков на nile-over-yql

---

### Plotter
— это python модуль позволяющий описывать все nile-цепочки операций в одном месте и реиспользовать уже посчитанные результаты для разных графиков. 

Полезен сервисам, кто из одних данных строит множество графиков

Описание на вики: https://wiki.yandex-team.ru/users/nerevar/imganalytics/plotter/

### Плюшки:
* единое понятное структурированное место для хранения всего nile кода
* живёт в аркадии, собирается в бинарник, есть юнит-тесты
* можно запускать в любом кроне (сейчас в хитмане и реакторе)
* реиспользование во множестве графиков один раз посчитанных данных
  * например за один проход по юзерсессиям можно сразу всё считать
  * сюда же — использование YQL бекенда для оптимизации вычислений
* код-ревью для качества кода и повышения информированности у всех о новых графиках/отчётах/логах
* документация по логам, операциям, выходным таблицам, визуализация в виде графа операций
* удобный запуск пересчётов в прошлое отчётов и табличек

### Как развернуть себе
Можно скопировать себе проект, поправить пути и рисовать в нём свои графики https://a.yandex-team.ru/arc/trunk/arcadia/analytics/plotter_example

### Файловая структура
* plotter.py — основной файл с описанием классов Plotter и Plot
* streams.py — описания подключения разных логов (user_sessions, redir-log и т.п.) и сырых yt таблиц
* utils.py — утилиты, хелперы, полезные всем
* digraph.py — код формирования визуализации — digraph на основе nile flow_graph
* templates/template.html — html шаблон с visjs network для визуализации графа
* tests — small и medium тесты

### Параметры запуска
```
$ ya nile libplotter.so -- --help

  --date DATE           Дата [начала], за которую обрабатывать логи в формате YYYY-MM-DD
  --dateend DATEEND     Дата окончания диапазона дат [date, dateend] в формате YYYY-MM-DD, необязательный параметр
  --token TOKEN         YT token
  --pool POOL           YT pool
  --stat-token TOKEN    Statface token
  --cluster CLUSTER     YT Cluster: hahn или arnold, по-умолчанию: hahn
  --dry-run, -d         Не запускать операции в YQL. Удобно для отладки или визуализации
  --save-flowchart [path]
                        Задаёт путь для сохранения html вьюера графа. По-умолчанию не пишется. При указании без параметров: plotter-vis.html
  -p [PLOTS ...], --plots [PLOTS ...]
                        Классы графиков, которые пересчитать. По-умолчанию — все из default layer
  -s STORE_CHECKPOINTS, --store-checkpoints STORE_CHECKPOINTS
                        Путь в YT без слеша на конце, куда сохранять данные чекпоинтов
  -c [CHECKPOINTS [CHECKPOINTS ...]], --checkpoints [CHECKPOINTS [CHECKPOINTS ...]]
                        Включает режим nile — начать расчёт с заданных чекпоинтов
  --force-checkpoints, -fc
                        Нужно ли все вычисляемые ноды сложить в YT в виде чекпоинтов
  --layers [LAYERS [LAYERS ...]], --layer [LAYERS [LAYERS ...]], -l [LAYERS [LAYERS ...]]
                        Слои для расчёта только тех узлов (графиков), которые помечены декоратором layer=NNN в require. По-умолчанию - всё, что без декоратора
  --1p, -1p             Использовать ли однопроцентные юзерсессии (в отладочных целях)

```
