import argparse, requests, sys, base64, hashlib, json, time, os
from multiprocessing import Pool
from PIL import Image
from io import BytesIO
import random
import numpy as np
from io import StringIO

def create_argument_parser():
    parser = argparse.ArgumentParser()

    parser.add_argument(
        '--input-file',
        required=True,
    )

    parser.add_argument(
        '--output-file',
        required=True,
    )

    parser.add_argument(
        '--new-url-field',
        required=True,
    )

    parser.add_argument(
        '--try-count',
        type=int,
        required=True,
    )

    parser.add_argument(
        '--url-field',
        required=True,
    )

    parser.add_argument(
        '--processes',
        required=True,
        type=int,
    )
    parser.add_argument(
        '--namespace',
        required=True,
    )

    parser.add_argument(
        '--environment',
        required=True,
    )

    return parser


def change_pixel(args):
    url, namespace, serv, try_count = args
    size = None #TODO
    timeout = 2 #TODO
    cur_try = 0
    while cur_try < try_count:
        cur_try += 1
        try:
            res = requests.get(url)
            if res.status_code != 200 and res.status_code != 404:
                raise Exception('Return code is {}'.format(res.status_code))

            img = Image.open(BytesIO(res.content))
            width, height = img.size
            pixel_x = random.randrange(height)
            pixel_y = random.randrange(width)
            delta = random.randrange(1, 11)
            if delta > 5:
                delta -= 11
            new_img = np.array(img)
            if img.format == 'GIF':
                return ''
            elif len(new_img.shape) > 2 and new_img.shape[2] > 2:
                for i in range(3):
                    if new_img[pixel_x, pixel_y, i] > 255 - delta:
                        new_img[pixel_x, pixel_y, i] -= delta
                    else:
                        new_img[pixel_x, pixel_y, i] += delta
                    if new_img[pixel_x, pixel_y, i] < -delta:
                        new_img[pixel_x, pixel_y, i] -= delta
                    else:
                        new_img[pixel_x, pixel_y, i] += delta
            else:
                return ''
                #if new_img[pixel_x, pixel_y] > 255 - delta:
                #    new_img[pixel_x, pixel_y] -= delta
                #else:
                #    new_img[pixel_x, pixel_y] += delta
                #if new_img[pixel_x, pixel_y] < -delta:
                #    new_img[pixel_x, pixel_y] -= delta
                #else:
                #    new_img[pixel_x, pixel_y] += delta
            new_img = Image.fromarray(np.uint8(new_img))

            image_name = base64.urlsafe_b64encode(hashlib.md5(url.encode('utf-8')).digest()).decode('unicode-escape')
            image_name = image_name.strip('=').strip('-')
            new_url = 'http://avatars-int.{serv}.yandex.net:13000/put-{namespace}/{image_name}'.format(\
                            serv=serv, namespace=namespace, image_name=image_name)
            new_img.save('temp_{image_name}.png'.format(image_name=image_name))
            files = {'file': open('temp_{image_name}.png'.format(image_name=image_name), 'rb')}
            res = requests.post(new_url, files=files)
            os.remove('temp_{image_name}.png'.format(image_name=image_name))

            if res.status_code != 200:
                raise Exception('Return code is {}'.format(res.status_code))
            response = json.loads(res.content.decode('unicode-escape'))
            if res.status_code == 400 and response['status'] != 'error':
                raise Exception('Can\'t upload image 400 code')
            print("Probably successful upload", response['sizes']['orig']['path'], new_url, file=sys.stderr)
            return 'http://avatars.mds.yandex.net' + response['sizes']['orig']['path']
        except Exception as e:
            print('Bad try for {}. {}'.format(url, str(e)), file=sys.stderr)
        time.sleep(timeout)
    return ''


def main():
    args = create_argument_parser().parse_args()

    with open(args.input_file, 'r') as f:
        input_data = json.load(f)

    files = []

    for i, elem in enumerate(input_data):
        src_url = elem[args.url_field]
        files.append(src_url)

    pool = Pool(processes=args.processes)
    response_urls = pool.map(change_pixel, [(src_url, args.namespace, args.environment, args.try_count) for src_url in files])
    output = []
    for elem, new_url in zip(input_data, response_urls):
        elem[args.new_url_field] = new_url
        output.append(elem)
    with open(args.output_file, 'w') as out_f:
        json.dump(output, out_f)

if __name__ == '__main__':
    main()
