#!/usr/bin/env python2
import argparse, json, sys
from utils import delete_image
from multiprocessing import Pool

def create_argument_parser():
    parser = argparse.ArgumentParser()

    parser.add_argument(
        '--input-file',
        required=True,
    )

    parser.add_argument(
        '--deleted-files',
        required=True,
    )

    parser.add_argument(
        '--undeleted-files',
        required=True,
    )

    parser.add_argument(
        '--try-count',
        type=int,
        required=True,
    )

    parser.add_argument(
        '--url-field',
        required=True,
    )

    parser.add_argument(
        '--processes',
        required=True,
        type=int,
    )

    return parser


def main():
    args = create_argument_parser().parse_args()

    with open(args.input_file, 'r') as f:
        input_data = json.load(f)

    deleted_files = []
    undeleted_files = []
    files_to_delete = []

    for i, elem in enumerate(input_data):
        src_url = elem[args.url_field]
        url_parts = src_url.split('/')

        if len(url_parts) < 6:
            print >>sys.stderr, 'Cannot delete file', src_url
            undeleted_files.append({'src_url': src_url})
            continue

        serv = url_parts[2].split('.')[1]
        namespace = url_parts[3].split('-', 1)[1]
        group_id, image_name = url_parts[4:6]

        files_to_delete.append((src_url, namespace, group_id, image_name, serv))

    pool = Pool(processes=args.processes)
    response_urls = pool.map(delete_image, [(namespace, group_id, image_name, serv, args.try_count) for src_url, namespace, group_id, image_name, serv in files_to_delete])

    for (src_url, namespace, group_id, image_name, serv), deleted_url in zip(files_to_delete, response_urls):
        #deleted_url = delete_image([namespace, group_id, image_name, serv, args.try_count])

        if deleted_url == '':
            print >>sys.stderr, 'Error while deleting from avatars', src_url
            undeleted_files.append({'src_url': src_url})

        print >>sys.stderr, 'Successfully deleted {} ({})'.format(src_url, deleted_url)
        deleted_files.append({'src_url': src_url, 'deleted_url': deleted_url})

    with open(args.deleted_files, 'w') as out_f:
        print >>out_f, json.dumps(deleted_files, indent=4).decode('unicode-escape').encode('utf8')

    with open(args.undeleted_files, 'w') as out_f:
        print >>out_f, json.dumps(undeleted_files, indent=4).decode('unicode-escape').encode('utf8')


if __name__ == '__main__':
    main()
