#!/usr/bin/env python2
import argparse, json, sys, tempfile, codecs
from utils import save_binaries_from_yt, upload_multiple_images

def create_argument_parser():
    parser = argparse.ArgumentParser()

    parser.add_argument(
        '--errors',
        required=True,
    )

    parser.add_argument(
        '--uploaded-images',
        required=True,
    )

    parser.add_argument(
        '--offset',
        type=int,
        required=True,
    )

    parser.add_argument(
        '--length',
        type=int,
        required=True,
    )

    parser.add_argument(
        '--try-count',
        type=int,
        required=True,
    )

    parser.add_argument(
        '--table-path',
        required=True,
    )

    parser.add_argument(
        '--cluster',
        required=True,
    )

    parser.add_argument(
        '--image-field',
        required=True,
    )

    parser.add_argument(
        '--key-field',
        required=True,
    )

    parser.add_argument(
        '--toloka-namespace',
        required=True,
    )

    parser.add_argument(
        '--environment',
        required=True,
    )

    parser.add_argument(
        '--processes',
        required=True,
        type=int,
    )

    return parser


def main():
    args = create_argument_parser().parse_args()

    images_dir = tempfile.mkdtemp(dir='.')
    files = save_binaries_from_yt(args.cluster, args.table_path, args.image_field, images_dir, args.offset, args.length, args.key_field)

    result, errors = upload_multiple_images(files, args.processes, args.toloka_namespace, args.environment, args.try_count)

    with codecs.open(args.uploaded_images, 'w', 'utf8') as out_f:
        json.dump(result, out_f, indent=4, ensure_ascii=False)

    with codecs.open(args.errors, 'w', 'utf8') as out_f:
        json.dump(errors, out_f, indent=4, ensure_ascii=False)


if __name__ == '__main__':
    main()
