import requests, sys, base64, hashlib, json, time, os
from subprocess import call
from multiprocessing import Pool

def check_image(filename):
    if call(['identify', filename]) == 0:
        return True
    return False


def save_binaries_from_yt(cluster_name, table_name, value_field, out_dir, offset, length, key_field=None):
    from nile.api.v1 import clusters as nile_clusters
    if cluster_name == 'hahn':
        cluster = nile_clusters.Hahn()
    elif cluster_name == 'banach':
        cluster_name = nile_clusters.Banach()
    else:
        raise Exception('Unsupported cluster {}'.format(cluster_name))

    if not os.path.exists(out_dir):
        os.makedirs(out_dir)

    records = cluster.read(table_name)
    sample = records[offset:offset+length]

    result = []

    for i, elem in enumerate(sample, offset):
        error_text = ''
        try:
            if key_field:
                key = elem[key_field]
            else:
                key = str(i)

            file_path = os.path.join(out_dir, str(i))
            contents = elem[value_field]

            with open(file_path, 'wb') as f:
                print >>sys.stderr, 'Saving file {}'.format(file_path)
                f.write(contents)
        except Exception as e:
            error_text = str(e)
            print >>sys.stderr, "Error while saving file.", error_text

        result.append({'file_path': file_path, 'key': key, 'errors': error_text})
    return result


def get_orig_avatars_url(serv, namespace, group_id, image_name):
    return 'http://avatars.{serv}.yandex.net/get-{namespace}/{group_id}/{image_name}/orig'.format(serv=serv, namespace=namespace, group_id=group_id, image_name=image_name)


def delete_image(args):
    namespace, group_id, image_name, serv, try_count = args
    size = None #TODO
    timeout = 2 #TODO
    cur_try = 0
    while cur_try < try_count:
        cur_try += 1
        try:
            url = 'http://avatars-int.{serv}.yandex.net:13000/delete-{namespace}/{group_id}/{image_name}'.format(\
                            serv=serv, namespace=namespace, group_id=group_id, image_name=image_name)
            if size:
                url += '/' + size

            res = requests.get(url)

            if res.status_code != 200 and res.status_code != 404:
                raise Exception('Return code is {}'.format(res.status_code))
            return url
        except Exception as e:
            print >>sys.stderr, 'Bad delete try for {}. {}'.format(url, str(e))
        time.sleep(timeout)
    return ''


def process_avatars_api_output(response):
    if not response or 'group-id' not in response or 'imagename' not in response or \
                'meta' not in response or 'crc64' not in response['meta'] or response['meta']['crc64'] == '':
        print >>sys.stderr, 'Cannot upload image', f['key']
        print >>sys.stderr, response
        return None, {'key': f['key'].decode('utf-8'), 'error': 'Avatars upload error'}

    image_name = response['imagename']
    group_id = response['group-id']
    crc = response['meta']['crc64'].lower()
    avatars_url = get_orig_avatars_url(mds_environment, toloka_namespace, group_id, image_name)

    return avatars_url, None


def upload_multiple_images(files, n_processes, toloka_namespace, mds_environment, try_count):
    result = []
    errors = []
    files_to_upload = []

    for f in files:
        if f['errors'] != '':
            errors.append({'key': f['key'].decode('utf-8'), 'error': f['errors']})
            continue

        if not check_image(f['file_path']):
            print >>sys.stderr, 'Non-valid file', f['key']
            errors.append({'key': f['key'].decode('utf-8'), 'error': 'Non-valid file'})
            continue

        files_to_upload.append(f)

    pool = Pool(processes=n_processes)
    response_array = pool.map(upload_local_image, [(toloka_namespace, mds_environment, x['file_path'], try_count) for x in files_to_upload])

    for f, response in zip(files_to_upload, response_array):
        avatars_url, avatars_error = process_avatars_api_output(response)
        if avatars_error is not None:
            errors.append(avatars_error)
            continue

        print >>sys.stderr, "Successful upload", f['key'], avatars_url

        result.append({ 'image_name': image_name,
                        'group_id': group_id,
                        'avatars_url': avatars_url,
                        'crc': crc,
                        'key': f['key'].decode('utf-8')
                        })
    return result, errors


def upload_local_image(args):
    namespace, serv, image_path, try_count = args
    timeout = 1 #TODO
    cur_try = 0
    while cur_try < try_count:
        cur_try += 1
        try:
            image_name = base64.urlsafe_b64encode(hashlib.md5(image_path).digest()[0:9])
            url = 'http://avatars-int.{serv}.yandex.net:13000/put-{namespace}/{image_name}'.format(\
                            serv=serv, namespace=namespace, image_name=image_name)
            files = {'file': open(image_path, 'rb')}

            res = requests.post(url, files=files)

            if res.status_code != 200:
                raise Exception('Return code is {}'.format(res.status_code))

            response = json.loads(res.content)

            if res.status_code == 400 and response['status'] != 'error':
                print res.content
                raise Exception('Can\'t upload image 400 code')
            print >>sys.stderr, "Probably successful upload", response['sizes']['orig']['path'], url
            return response
        except Exception as e:
            print >>sys.stderr, 'Bad put try for {}. {}'.format(url, str(e))
        time.sleep(timeout)
    return None
