import codecs
import json
import sys

in_filename = sys.argv[1]
fresh_filename = sys.argv[2]
w1_filename = sys.argv[3]
w2_filename = sys.argv[4]
w3_filename = sys.argv[5]

with codecs.open(in_filename, 'r', 'utf8') as f:
    data = json.load(f, encoding='utf8')

out_fresh = []
out_w1 = []
out_w2 = []
out_w3 = []

for elem in data:
    if elem.get('query_freshness', 'NOT_JUDGED') in ['IMAGE_POSSIBLE', 'IMAGE_FRESH']:
        out_fresh.append(elem)
    elif elem.get('wideness', 'NOT_JUDGED') == 'wideness_1':
        out_w1.append(elem)
    elif elem.get('wideness', 'NOT_JUDGED') == 'wideness_2':
        out_w2.append(elem)
    else:
        out_w3.append(elem)

with codecs.open(fresh_filename, 'w', 'utf8') as f:
    json.dump(out_fresh, f, indent=4, ensure_ascii=False)

with codecs.open(w1_filename, 'w', 'utf8') as f:
    json.dump(out_w1, f, indent=4, ensure_ascii=False)

with codecs.open(w2_filename, 'w', 'utf8') as f:
    json.dump(out_w2, f, indent=4, ensure_ascii=False)

with codecs.open(w3_filename, 'w', 'utf8') as f:
    json.dump(out_w3, f, indent=4, ensure_ascii=False)

