import os, sys, json, tempfile
from urllib2 import urlopen

def download_single_image(args):
    img_url, dst_dir, abspath = args
    try:
        resp = urlopen(img_url)
        if resp.code != 200:
            raise Exception('Return code is {}'.format(resp.ret_code))

        filename = tempfile.mktemp(dir=dst_dir)
        if abspath:
            filename = os.path.abspath(filename)

        with open(filename, 'wb') as f:
            f.write(resp.read())

        return {'filename': filename, 'url': img_url, 'info': "Successful download for {}".format(img_url)}
    except Exception as e:
        return {'url': img_url, 'info': "Error while downloading {}: {}".format(img_url, str(e))}


def download_images(images, dst_dir, abspath=True):
    downloaded_images = []

    try:
        if not os.path.exists(dst_dir):
            os.makedirs(dst_dir)
    except Exception as e:
        print >>sys.stderr, "Error while creating temporary dir {}: {}".format(dst_dir, str(e))
        return downloaded_images

    for img_url in images:
        status = download_single_image((img_url, dst_dir, abspath))
        downloaded_images.append(status)
        print >>sys.stderr, status['info']

    return downloaded_images


def main():
    if len(sys.argv) != 2:
        print >>sys.stderr, 'Usage:', sys.argv[0], '<dir>'
        sys.exit(1)

    out_dir = sys.argv[1]
    images = sys.stdin.read().splitlines()
    result = download_images(images, out_dir)
    print json.dumps(result, indent=4)


if __name__ == '__main__':
    main()
