from download_images import download_single_image
import json, codecs
from multiprocessing import Pool
import sys

if len(sys.argv) != 5:
    print >>sys.stderr, "Usage:", sys.argv[0], "<in_file> <n_proc> <dst_dir> <out_file>"
    sys.exit(1)

in_file = sys.argv[1]
n_proc = int(sys.argv[2])
dst_dir = sys.argv[3]
out_file = sys.argv[4]

with codecs.open(in_file, 'r', 'utf8') as f:
    in_data = json.load(f, encoding='utf8')

images = [ x['image_avatars_url'] for x in in_data if x['image_avatars_url'] ]
print >>sys.stderr, "Total {} input urls".format(len(images))

pool = Pool(processes=n_proc)
result = pool.map(download_single_image, [(img, dst_dir, True) for img in images])

with codecs.open(out_file, 'w', 'utf8') as f:
    json.dump(result, f, ensure_ascii=False, indent=2)
