import yt.wrapper as yt
import json, sys

if len(sys.argv) != 5:
    print >>sys.stderr, "Usage:", sys.argv[0], "<in_filename> <yt_table> <key_field> <image_field>"
    sys.exit(1)

in_filename = sys.argv[1]
yt_table = sys.argv[2]
key_field = sys.argv[3]
image_field = sys.argv[4]

with open(in_filename, 'r') as f:
    data = json.load(f)

binary_table = []

def read_image(key, path):
    with open(path, 'rb') as f:
        image = f.read()
    return {'key': key, 'image': image}

for elem in data:
    binary_table.append(read_image(elem[key_field], elem[image_field]))

yt.write_table(yt_table, binary_table)
