import yt.wrapper as yt
from datetime import datetime
import os

def main(*args):
    params_wrapped, in2, in3, token, any_param, html_file = args

    yt.update_config({"proxy": {"url": "hahn.yt.yandex.net"}, "token": token})

    params = params_wrapped[0]
    days_to_parse = params['days_to_parse']
    root_dir = params['root_dir']

    prev_state = yt.get_attribute(root_dir, 'current_state')
    new_state = datetime.now().strftime('%Y-%m-%d')

    log_days = sorted(yt.list(params['logs_dir']))
    if days_to_parse <= 1:
        days_range = log_days[-1]
    else:
        last_logs = log_days[-days_to_parse:]
        days_range = '{{{}..{}}}'.format(last_logs[0], last_logs[-1])

    params['prev_state'] = prev_state
    params['new_state'] = new_state
    params['prev_state_path'] = os.path.join(root_dir, prev_state)
    params['new_state_path'] = os.path.join(root_dir, new_state)
    params['days_range'] = days_range
    params['export_table_path'] = os.path.join(params['export_dir'], new_state)
    params['toloka_markup_table_path'] = os.path.join(root_dir, new_state, '10_toloka_markup')

    return [params]
