import yt.wrapper as yt
import os
import sys

def main(*args):
    params_wrapped, in2, in3, token, any_param, html_file = args

    yt.update_config({"proxy": {"url": "arnold.yt.yandex.net"}, "token": token})

    params = params_wrapped[0]

    state = params['yt_input_table_suffix']
    robot_dump_state_dir = os.path.join(params['robot_dump_dir'], state)

    current_prod_state = yt.get_attribute(params['robot_prod_dir'], 'prod_state')
    new_prod_state = state.replace('-', '') + '-000000'

    if current_prod_state == new_prod_state:
        print >>sys.stderr, "Current and new prod states match, aborting"
        sys.exit(1)

    params['current_prod_state'] = current_prod_state
    params['new_prod_state'] = new_prod_state
    params['robot_src_table'] = os.path.join(params['robot_dump_dir'], 'prod')
    params['robot_dst_table'] = os.path.join(params['robot_prod_dir'],
                                            new_prod_state,
                                            "watermark.features")
    params['robot_dump_state_dir'] = robot_dump_state_dir
    params['robot_src_dump_table'] = os.path.join(robot_dump_state_dir, "01_src")
    params['robot_dst_dump_table'] = os.path.join(robot_dump_state_dir, "10_dst")

    return params
