#!/usr/bin/env python2
import sys, random, tempfile, os
from PIL import Image
from utils import concat_images, RandomTransform

def single_image_transform(in_filename, mode, concat, n_transforms, out_filename):
    img = Image.open(in_filename)
    if img.format != 'JPEG':
        print >>sys.stderr, "File {} is not in JPEG format".format(in_filename)
        return False

    transform = RandomTransform(img, mode)
    if transform.valid_size():
        new_img = transform.run_sequence(n_transforms)

        if concat:
            new_img = concat_images([img, new_img], 50)

        new_img.save(out_filename, "JPEG")
    else:
        print >>sys.stderr, "File {} is not valid for generating a transformation".format(in_filename)
        return False

    return True


def multiple_images_transform(images, mode, n_transforms, tmp_dir):
    if not os.path.exists(tmp_dir):
        os.makedirs(tmp_dir)

    if mode == 'pos':
        label = 'DUPLICATES'
    elif mode == 'neg':
        label = 'NON_DUPLICATES'
    else:
        raise Exception('Unnkown transformation mode {}'.format(mode))

    result = []

    for img in images:
        in_img_path = img['filename']
        out_img_path = os.path.abspath(tempfile.mktemp(dir=tmp_dir))
        try:
            success = single_image_transform(in_img_path, mode, False, n_transforms, out_img_path)
        except Exception as e:
            print >>sys.stderr, "Error while running transformation for image {}: {}".format(in_img_path, str(e))
            success = False

        if success:
            result.append({'filename': in_img_path, 'transform': out_img_path, 'label': label, 'url': img['url']})

    return result


def main():
    if len(sys.argv) != 6:
        print >>sys.stderr, 'Usage:', sys.argv[0], '<src_img> <mode: pos|neg> <save_concat: no|yes> <n> <dst_img>'
        sys.exit(1)

    src_img_path = sys.argv[1]
    mode = sys.argv[2]
    if sys.argv[3] == "yes":
        is_concat = True
    else:
        is_concat = False
    n_transforms = int(sys.argv[4])
    dst_img_path = sys.argv[5]

    random.seed()
    single_image_transform(src_img_path, mode, is_concat, n_transforms, dst_img_path)


if __name__ == '__main__':
    main()
