from collections import defaultdict
import re
import sys

def main(*args):
    data, metrics_config, crons_config, token, any_param, html_file = args

    comments = defaultdict(list)

    for data_elem in data:
        index_pub_date = data_elem['value']
        if not re.match(r'^[0-9]{8}-[0-9]{6}$', index_pub_date):
            print >>sys.stderr, "Unknown value date format"
            sys.exit(1)
        for metrics_group in metrics_config:
            index_type = metrics_group['type']
            index_state = data_elem['index_info'][index_type]
            comment_message = '{}: {}'.format(index_type, index_state)
            for metric in metrics_group['metrics']:
                comments[(metric, index_pub_date)].append(comment_message)

    out_data = []

    for key in comments:
        metric, index_pub_date = key
        yyyy = index_pub_date[0:4]
        mm = index_pub_date[4:6]
        dd = index_pub_date[6:8]
        comment_messages = comments[key]

        out_data.append({
                            "config": {
                                "cronId": crons_config[0]['cronId'],
                                "filter": {
                                    "system": crons_config[0]['system'],
                                    "metric": metric
                                }
                            },
                            "date": "{}-{}-{}T00:00:00+03:00".format(yyyy, mm, dd),
                            "user": crons_config[0]['user'],
                            "comment": '<br/>'.join(comment_messages)
                        })

    return out_data
