import yt.wrapper as yt

def main(*args):
    data, in2, in3, token, any_param, html_file = args

    yt.update_config({"proxy": {"url": "arnold.yt.yandex.net"}, "token": token})

    for elem in data:
        if 'SEMIDUPS_STATE' not in elem['index_info']:
            continue
        public_state = elem['index_info']['SEMIDUPS_STATE']
        info_table = '//home/cvdup/semidups/public/production/{}/source_list'.format(public_state)
        if not yt.exists(info_table):
            info_table = '//home/cvdup/semidups/public/production_sources_history/{}/source_list'.format(public_state)

        state_info = list(yt.read_table(info_table))

        base_state = ''
        n_incs = 0

        for source in state_info:
            if source['value'] == 'base':
                base_state = source['key']
            else:
                n_incs += 1

        if base_state == '':
            base_state = 'NOT_FOUND'

        elem['index_info']['SEMIDUPS_BASE_STATE'] = base_state
        elem['index_info']['SEMIDUPS_INCREMENTS'] = str(n_incs)

    return data
