import codecs
import sys
import json
from itertools import combinations

in_filename = sys.argv[1]
out_filename = sys.argv[2]

with codecs.open(in_filename, 'r', 'utf8') as f:
    data = json.load(f, encoding='utf8')

DEVICE_MAP = {0: 'DESKTOP',
            1: 'ANDROID',
            2: 'IPHONE',
            3: 'UNKNOWN',
            4: 'WINDOWS_PHONE'}

out_data = []

for serp in data:
    if 'components' not in serp:
        continue

    query = serp['query']

    for comp1, comp2 in combinations(serp['components'][:10], 2):
        if 'judgements.images_dbd_pointwise_signal' not in comp1 or 'judgements.images_dbd_pointwise_signal' not in comp2:
            continue

        if abs(comp1['judgements.images_dbd_pointwise_signal']['value'] - comp2['judgements.images_dbd_pointwise_signal']['value']) > 0.65:
            if comp1['judgements.images_dbd_pointwise_signal']['value'] > comp2['judgements.images_dbd_pointwise_signal']['value']:
                result = 'left'
            else:
                result = 'right'

            out_data.append({
                            'query_text': query['text'],
                            'query_region_id': query['regionId'],
                            'query_country': query['country'],
                            'query_device': DEVICE_MAP.get(query['device'], DEVICE_MAP[3]),
                            'queryfresh': serp.get('serp_query_param.queryfresh'),
                            'left_image_url': comp1.get('url.imageUrl'),
                            'left_image_mds': comp1.get('url.mimcaMdsUrl'),
                            'left_snippet': comp1.get('text.snippet'),
                            'left_title': comp1.get('text.title'),
                            'left_page_url': comp1.get('componentUrl', {}).get('pageUrl'),
                            'left_relevance': comp1.get('judgements.RELEVANCE', {}).get('name'),
                            'left_dbd': comp1.get('judgements.images_dbd_pointwise_signal', {}).get('value'),
                            'right_image_url': comp2.get('url.imageUrl'),
                            'right_image_mds': comp2.get('url.mimcaMdsUrl'),
                            'right_snippet': comp2.get('text.snippet'),
                            'right_title': comp2.get('text.title'),
                            'right_page_url': comp2.get('componentUrl', {}).get('pageUrl'),
                            'right_relevance': comp2.get('judgements.RELEVANCE', {}).get('name'),
                            'right_dbd': comp2.get('judgements.images_dbd_pointwise_signal', {}).get('value'),
                            'prior_result': result
                            })

with codecs.open(out_filename, 'w', 'utf8') as f:
    json.dump(out_data, f, ensure_ascii=False, indent=2)
