import sys
import datetime
import time

def wait_for_time_period(time_from, time_to):
    now = datetime.datetime.now()
    now_time_str = now.strftime('%H:%M:%S')
    print >>sys.stderr, 'Now: {}, target: [{}; {})'.format(now_time_str, time_from, time_to)
    if now_time_str >= time_from and now_time_str < time_to:
        print >>sys.stderr, "Already within time period, no waiting"
        return
    hour, minute, second = map(int, time_from.split(':'))
    target_time = datetime.datetime(now.year, now.month, now.day, hour, minute, second)
    if now_time_str > time_to: # wait for tomorrow
        target_time += datetime.timedelta(days=1)

    time_to_wait = target_time - now
    seconds_to_wait = int(time_to_wait.total_seconds())
    print >>sys.stderr, "Seconds to wait:", seconds_to_wait
    time.sleep(seconds_to_wait)

if __name__ == '__main__':
    wait_for_time_period(sys.argv[1], sys.argv[2])
