import sys
import argparse
import json
import time
import logging
from collections import Counter
from pprint import pprint
from toloka_api_request import custom_toloka_request

def create_argument_parser():
    parser = argparse.ArgumentParser()

    parser.add_argument('--token', required=True)
    parser.add_argument('--pool-id-field', default='poolId')
    parser.add_argument('--output-values-field', required=True)
    parser.add_argument('--sleep-time', type=int, default=5)
    parser.add_argument('--assessments-limit', type=int, required=True)
    parser.add_argument('--input', required=True)
    parser.add_argument('--output', required=True)

    return parser


def get_pool_status(pool_id, token):
    status = custom_toloka_request('pools/{}'.format(pool_id), 'GET', token, {})
    return status['status']


def assignments_status_loop(pool_id, output_values_field, token, sleep_time, assessments_limit):
    logging.info('Starting assessments status loop')

    while True:
        pool_assignments = custom_toloka_request('assignments'.format(pool_id),
                'GET', token, {'pool_id': pool_id, 'status': 'ACCEPTED', 'limit': assessments_limit})

        result_labels = Counter()

        for item in pool_assignments['items']:
            label = item['solutions'][0]['output_values'].get(output_values_field, "NOT_FOUND")
            result_labels[label] += 1

        logging.info('Label counters: ' + str(result_labels.most_common()))

        pool_status = get_pool_status(pool_id, token)
        logging.info('Pool {} is {}'.format(pool_id, pool_status))

        if pool_status != 'OPEN':
            break

        time.sleep(sleep_time)

    logging.info('Assignments status loop is finished')


def main():
    logging.basicConfig(format='%(asctime)s - %(name)s - %(levelname)s - %(message)s',
             level=logging.INFO)
    logging.info('Started')

    args = create_argument_parser().parse_args()
    logging.info('Sleep time {}'.format(args.sleep_time))

    with open(args.input, 'r') as f:
        in_data = json.load(f)
        logging.info('Input file is loaded')

    assignments_status_loop(in_data[0][args.pool_id_field], args.output_values_field,
                            args.token, 60 * args.sleep_time, args.assessments_limit)

    with open(args.output, 'w') as f:
        print >>f, 'SYNC'
        logging.info('SYNC')


if __name__ == '__main__':
    main()
