import sys
import argparse
import json
import urllib2
import codecs

def create_argument_parser():
    parser = argparse.ArgumentParser()

    parser.add_argument('--token', required=True)
    parser.add_argument('--request-type', required=True)
    parser.add_argument('--request-text', required=True)
    parser.add_argument('--output', required=True)
    parser.add_argument('--input', required=False)
    parser.add_argument('--environment', required=True)

    parser.add_argument('--params', required=False, default='')

    return parser


def custom_toloka_request(request_text, request_type, token, props, data={}, sandbox=False, yang=False):
        headers = {'Content-Type': 'application/JSON', 'Authorization': 'OAuth ' + token}

        if yang:
            env = "yang"
            domain = "yandex-team"
        else:
            env = "toloka"
            domain = "yandex"

        if sandbox:
            prefix = "sandbox."
        else:
            prefix = ""

        url = 'https://{prefix}{env}.{domain}.ru/api/v1/{req}'.format(prefix=prefix, env=env, domain=domain, req=request_text)

        if props:
            url += '?' + dict_to_cgi(props)
        print >>sys.stderr, "Request url:", url

        if request_type.upper() == 'PUT':
            req = urllib2.Request(url, data=json.dumps(data), headers=headers)
        else:
            req = urllib2.Request(url, headers=headers)
        req.get_method = lambda: request_type.upper()

        res = urllib2.urlopen(req)

        return json.loads(res.read())


def dict_to_cgi(d):
    return '&'.join(['='.join(map(str, kv)) for kv in d.items()])


def parse_tskv_string(s, sep=','):
    if s == "":
        return {}

    parts = s.split(sep)
    return dict([ kv.split('=') for kv in parts ])


# (sandbox, yang)
ENV = {
        "PRODUCTION": (False, False),
        "SANDBOX_YANDEX": (True, False),
        "YANG_PRODUCTION": (False, True),
        "YANG_SANDBOX": (True, True)
}


def main():
    args = create_argument_parser().parse_args()

    if args.request_type.upper() not in ['GET', 'DELETE', 'PUT']:
        print >>sys.stderr, "request_type should be GET|DELETE|PUT"
        sys.exit(1)

    sandbox, yang = ENV[args.environment]

    params = parse_tskv_string(args.params)
    print >>sys.stderr, "Params:", json.dumps(params)

    if args.input:
        with codecs.open(args.input, 'r', 'utf8') as f:
            data = json.load(f, encoding='utf8')
    else:
        data = {}

    result = custom_toloka_request(request_text=args.request_text,
                                    request_type=args.request_type,
                                    token=args.token,
                                    props=params,
                                    data=data,
                                    sandbox=sandbox,
                                    yang=yang)

    with codecs.open(args.output, 'w', 'utf8') as f:
        json.dump(result, f, indent=4, ensure_ascii=False)


if __name__ == '__main__':
    main()
