# -*- coding: utf-8 -*-
import sys, codecs, json
from bs4 import BeautifulSoup as BS

if len(sys.argv) != 4:
    print >>sys.stderr, "Usage:", sys.argv[0], "<template> <tasks> <limit>"
    sys.exit(1)

template_filename = sys.argv[1]
tasks_filename = sys.argv[2]
limit = int(sys.argv[3])

with codecs.open(template_filename, encoding='utf-8') as f:
    template = f.read()

row_template = """<tr>
      <td align=center>
        <div class="image">
            <img src={image_left} class="original_size" real-size=true>
        </div>
      </td>
      <td align=center>
        <div>
            Output: {label}
            <br/>
            Honeypot: {honeypot}
        </div>
      </td>
      <td align=center>
        <div class="image">
            <img src={image_right} class="original_size" real-size=true>
            </div>
      </td>
    </tr>"""

table_rows = ''

with codecs.open(tasks_filename, encoding='utf-8') as f:
    tasks_json = json.load(f)

tasks = []
for elem in tasks_json:
    images = sorted([elem['inputValues']['image_left'], elem['inputValues']['image_right']])
    label = elem['outputValues']['result']
    hp = elem['knownSolutions'][0]['outputValues']['result']
    tasks.append(images + [label, hp])

tasks.sort()

if limit > 0:
    tasks = tasks[:limit]

total_tasks = len(tasks)

for cnt, dups in enumerate(tasks, 1):
    sys.stderr.write('\rProgress: {}/{}'.format(cnt, total_tasks))
    table_rows += row_template.format(image_left=dups[0], image_right=dups[1], label=dups[2], honeypot=dups[3])

print >>sys.stderr, ""

final_html = template.format(table_rows=table_rows)

soup = BS(final_html, 'lxml')
print soup.prettify(encoding='utf-8')
