import url_ndp
import json
import sys
from urllib2 import urlparse

def append_owner(data, url_field='url', owner_field='owner'):
    owner_formatter = url_ndp.Formatter('%y', ':'.join(['areas.lst'])) # multiple files may be used

    for elem in data:
        owner = owner_formatter.FormatUrl(str(urlparse.unquote(elem[url_field].encode('utf8'))))
        elem[owner_field] = owner

    return data


if __name__ == '__main__':
    in_filename = sys.argv[1]
    out_filename = sys.argv[2]

    with open(in_filename, 'r') as f:
        data = json.load(f)

    out_data = append_owner(data)

    with open(out_filename, 'w') as f:
        json.dump(out_data, f, indent=4)
