#!/bin/bash

if [[ "$#" -ne "3" ]]; then
    echo "Usage: $0 <in_table> <out_table> <schema>" >&2
    echo "Example: {name = uid; type = string; required = false}; {name = query; type = string;required=true}; {name = platform; type = string; required = true }; { name = clicks; type = int64 }; {name = pos; type = int64}; {name = s; type = string}" >&2
    exit 1
fi

yt merge --mode ordered --src $1 --dst '<schema=<strict=%true>'"[$3]>$2" --spec '{schema_inference_mode = from_output; force_transform = %true}'
