#!/usr/bin/env python2
import yt.wrapper as yt
import argparse, json, sys


def create_argument_parser():
    parser = argparse.ArgumentParser()

    parser.add_argument(
        '--input-file',
        required=True
    )

    parser.add_argument(
        '--src-field',
        required=True,
    )

    parser.add_argument(
        '--dst-field',
        required=True,
    )

    parser.add_argument(
        '--cluster',
        required=True,
    )

    parser.add_argument(
        '--output-tables',
        required=True,
    )

    parser.add_argument(
        '--error-tables',
        required=True,
    )

    return parser


def main():
    args = create_argument_parser().parse_args()
    yt.config.set_proxy(args.cluster)

    moved_tables = []
    error_tables = []

    with open(args.input_file, 'r') as f:
        in_data = json.load(f)

    for elem in in_data:
        if args.src_field not in elem or args.dst_field not in elem:
            print >>sys.stderr, "src or dst field not found in", elem
            error_tables.append(elem)
            continue
        yt.move(elem[args.src_field], elem[args.dst_field])
        moved_tables.append(elem)


    with open(args.output_tables, 'w') as f:
        json.dump(moved_tables, f, indent=4)

    with open(args.error_tables, 'w') as f:
        json.dump(error_tables, f, indent=4)


if __name__ == '__main__':
    main()
