PRAGMA dq.AnalyzeQuery = "1";
PRAGMA yson.DisableStrict = '1';
PRAGMA yt.TemporaryAutoMerge = 'disabled';

$query_stats = (
    SELECT 
        engine, engine_ui,
        cluster,
        norm_query AS query,
        SUM(row_weight) AS cnt,
        SUM(row_weight * C2_prob) AS cntC2,
    FROM {{input1}}
    GROUP BY engine, engine_ui, cluster, norm_query
); 

INSERT INTO `//home/searchshare/dashboard/clusters/tops/top_queries` WITH TRUNCATE 
SELECT
    engine, engine_ui,
    cluster,
    qt.0 AS cnt,
    qt.1 AS query,
FROM (
    SELECT
        engine, engine_ui,
        cluster,
        TOP((cnt, query), 20) AS q_list
    FROM $query_stats
    GROUP BY engine, engine_ui, cluster
)
FLATTEN LIST BY q_list AS qt
ORDER BY cluster;

INSERT INTO `//home/searchshare/dashboard/clusters/tops/top_queries_c2` WITH TRUNCATE 
SELECT
    engine, engine_ui,
    cluster,
    qt.0 AS cntC2,
    qt.1 AS query,
FROM (
    SELECT
        engine, engine_ui,
        cluster,
        TOP((cntC2, query), 20) AS q_list
    FROM $query_stats
    GROUP BY engine, engine_ui, cluster
)
FLATTEN LIST BY q_list AS qt
ORDER BY cluster;
