def attach_money(actions):
    queries = []
    query, revenue, ts, ui = None, None, None, None
    for a in actions:
        if a.query is not None:
            if query is not None:
                queries.append({"query": query, "revenue": revenue, "ui": ui, "ts": ts})
            query = a.query
            revenue = dict()
            ts = a.ts
            ui = a.ui
        # money
        elif query is not None and a.revenue is not None and a.ts - ts < 60 * 30:
            revenue[a.service] = revenue.get(a.service, 0) + a.revenue
    if query is not None:
        queries.append({"query": query, "revenue": revenue, "ui": ui, "ts": ts})
    return queries
