USE hahn;
PRAGMA yt.DefaultMaxJobFails = '1';
PRAGMA yt.TemporaryAutoMerge = 'disabled';

DECLARE $start_date AS String;
DECLARE $yt_pool AS String;

PRAGMA yt.Pool = $yt_pool;

$prev_month = DateTime::Format("%Y-%m")(DateTime::ShiftMonths(CAST($start_date AS Date), -1));
$cube_month = "//home/searchshare/squeeze_cube/" || $prev_month;


$t = SELECT 
    query,
    CAST(SOME(cluster) AS String) AS cluster,
    COUNT(*) AS cnt,
    SUM(revenue) ?? 0 AS revenue,
    COUNT_IF(ui=='touch') AS cnt_touch,
    COUNT_IF(ui=='desktop') AS cnt_desktop
FROM $cube_month
GROUP BY query
HAVING COUNT(*) >= 30;

INSERT INTO `//home/searchshare/dashboard/cube_datasets/queries` WITH TRUNCATE 
SELECT * FROM $t AS res
LEFT JOIN ANY (
    SELECT cluster_id AS cluster, cluster_name, middle_cluster_name, parent_cluster_name
    FROM `//home/searchshare/dashboard/cluster_tree`
) AS t
USING(cluster)
WHERE res.cluster IS NOT NULL
ORDER BY query;
